/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.events.mappings;

import epicsquid.mysticalworld.MysticalWorld;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class Remaps {
    public static Map<ResourceLocation, ResourceLocation> remappedItems = new HashMap<ResourceLocation, ResourceLocation>();
    public static Map<ResourceLocation, ResourceLocation> remappedBlocks = new HashMap<ResourceLocation, ResourceLocation>();
    public static Map<ResourceLocation, ResourceLocation> remappedEntities = new HashMap<ResourceLocation, ResourceLocation>();

    private static void remap(String oldName, String newName, RemapType type) {
        Map<ResourceLocation, ResourceLocation> remapper = type.getMap().get();
        String mapType = type.getName();
        ResourceLocation oldRL = new ResourceLocation("mysticalworld", oldName);
        ResourceLocation newRL = new ResourceLocation("mysticalworld", newName);
        if (remapper.containsKey(oldRL)) {
            MysticalWorld.LOG.error("Invalid " + mapType + " remap: " + oldRL.toString() + " already exists and remaps to " + remapper.get(oldRL).toString() + ", cannot also remap to " + newRL.toString(), (Throwable)new IllegalStateException("Duplicate " + mapType + " remap"));
        }
        remapper.put(oldRL, newRL);
    }

    public static void remapItem(String o, String n) {
        Remaps.remap(o, n, RemapType.ITEM);
    }

    public static void remapBlock(String o, String n) {
        Remaps.remap(o, n, RemapType.BLOCK);
    }

    public static void remapEntity(String o, String n) {
        Remaps.remap(o, n, RemapType.ENTITY);
    }

    public static void remapItemEvent(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedItems.get(mapping.key);
            if (remap == null) continue;
            mapping.remap(Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(remap)));
        }
    }

    public static void remapBlockEvent(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedBlocks.get(mapping.key);
            if (remap == null) continue;
            mapping.remap(Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(remap)));
        }
    }

    public static void remapEntityEvent(RegistryEvent.MissingMappings<EntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedEntities.get(mapping.key);
            if (remap == null) continue;
            mapping.remap(Objects.requireNonNull(ForgeRegistries.ENTITIES.getValue(remap)));
        }
    }

    static {
        Remaps.remapItem("young_pearl", "young_pearl");
    }

    public static enum RemapType {
        ITEM("item", () -> remappedItems),
        BLOCK("block", () -> remappedBlocks),
        ENTITY("entity", () -> remappedEntities);

        private String name;
        private Supplier<Map<ResourceLocation, ResourceLocation>> map;

        public String getName() {
            return this.name;
        }

        public Supplier<Map<ResourceLocation, ResourceLocation>> getMap() {
            return this.map;
        }

        private RemapType(String name, Supplier<Map<ResourceLocation, ResourceLocation>> map) {
            this.name = name;
            this.map = map;
        }
    }
}

