/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.init;

import com.google.common.collect.Lists;
import epicsquid.mysticalworld.MWTags;
import epicsquid.mysticalworld.MysticalWorld;
import epicsquid.mysticalworld.init.ModBlocks;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.mysticalworld.repack.registrate.providers.ProviderType;
import epicsquid.mysticalworld.repack.registrate.providers.RegistrateTagsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModTags {
    public static void load() {
    }

    static {
        MysticalWorld.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, p -> {
            ItemBuilder b = new ItemBuilder((RegistrateTagsProvider)p);
            b.additional((Tag<Item>)Tags.Items.ORES).add(MWTags.Items.AMETHYST_ORE, MWTags.Items.COPPER_ORE, MWTags.Items.LEAD_ORE, MWTags.Items.QUICKSILVER_ORE, MWTags.Items.SILVER_ORE, MWTags.Items.TIN_ORE);
            b.add((Tag<Item>)MWTags.Items.SWEETS, new IItemProvider[]{Items.field_151102_aT, Items.field_151034_e, Items.field_151106_aX, Items.field_151127_ba, Items.field_222070_lD, Items.field_151158_bO, Items.field_185164_cV});
            b.add((Tag<Item>)MWTags.Items.FISH, new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX, Items.field_196088_aY, (IItemProvider)ModItems.RAW_SQUID.get()});
            b.add((Tag<Item>)MWTags.Items.COOKED_FISH, new IItemProvider[]{Items.field_196102_ba, Items.field_196104_bb, (IItemProvider)ModItems.COOKED_SQUID.get()});
            b.add((Tag<Item>)MWTags.Items.MEAT, new IItemProvider[]{Items.field_151082_bd, Items.field_179561_bm, Items.field_179558_bo, Items.field_151147_al, Items.field_151076_bf, (IItemProvider)ModItems.VENISON.get()});
            b.add((Tag<Item>)MWTags.Items.COOKED_MEAT, new IItemProvider[]{Items.field_151083_be, Items.field_151077_bg, Items.field_179557_bn, Items.field_151157_am, Items.field_179559_bp, (IItemProvider)ModItems.COOKED_VENISON.get()});
            b.additional((Tag<Item>)MWTags.Items.PROTEIN).add(MWTags.Items.FISH, MWTags.Items.COOKED_FISH, MWTags.Items.MEAT, MWTags.Items.COOKED_MEAT);
            b.add((Tag<Item>)MWTags.Items.PROTEIN, new IItemProvider[]{Items.field_151110_aK, Items.field_151078_bh});
            b.add((Tag<Item>)MWTags.Items.AUBERGINE, new Supplier[]{ModItems.AUBERGINE});
            b.add((Tag<Item>)MWTags.Items.EGGPLANT, (Tag<Item>)MWTags.Items.AUBERGINE);
            b.add((Tag<Item>)Tags.Items.STRING, new Supplier[]{ModItems.SILK_THREAD});
            b.add((Tag<Item>)MWTags.Items.SLIME_BLOCK, new IItemProvider[]{Items.field_221904_fj});
            b.additional((Tag<Item>)Tags.Items.STORAGE_BLOCKS).add(MWTags.Items.AMETHYST_BLOCK, MWTags.Items.COPPER_BLOCK, MWTags.Items.LEAD_BLOCK, MWTags.Items.QUICKSILVER_BLOCK, MWTags.Items.SILVER_BLOCK, MWTags.Items.TIN_BLOCK);
            b.add((Tag<Item>)MWTags.Items.SOFT_STONE, new Supplier[]{ModBlocks.SOFT_STONE});
            b.add((Tag<Item>)Tags.Items.STONE, new Supplier[]{ModBlocks.SOFT_STONE});
            b.add((Tag<Item>)MWTags.Items.SLIME, new IItemProvider[]{Items.field_151123_aH});
            b.add((Tag<Item>)Tags.Items.GEMS, (Tag<Item>)MWTags.Items.AMETHYST_GEM);
            b.additional((Tag<Item>)Tags.Items.INGOTS).add(MWTags.Items.COPPER_INGOT, MWTags.Items.LEAD_INGOT, MWTags.Items.QUICKSILVER_INGOT, MWTags.Items.SILVER_INGOT, MWTags.Items.TIN_INGOT);
            b.additional((Tag<Item>)Tags.Items.NUGGETS).add(MWTags.Items.COPPER_NUGGET, MWTags.Items.LEAD_NUGGET, MWTags.Items.QUICKSILVER_NUGGET, MWTags.Items.SILVER_NUGGET, MWTags.Items.TIN_NUGGET);
            b.additional((Tag<Item>)Tags.Items.DUSTS).add(MWTags.Items.COPPER_DUST, MWTags.Items.LEAD_DUST, MWTags.Items.QUICKSILVER_DUST, MWTags.Items.SILVER_DUST, MWTags.Items.TIN_DUST, MWTags.Items.GOLD_DUST, MWTags.Items.IRON_DUST);
            b.add((Tag<Item>)MWTags.Items.GEMS, new Supplier[]{ModItems.AMETHYST_GEM, () -> Items.field_151045_i});
            b.add((Tag<Item>)MWTags.Items.VEGETABLES, new IItemProvider[]{Items.field_151172_bF, Items.field_185164_cV});
            b.add((Tag<Item>)MWTags.Items.COOKED_VEGETABLES, new Supplier[]{ModItems.COOKED_BEETROOT, ModItems.COOKED_CARROT, () -> Items.field_151168_bH});
            b.add((Tag<Item>)MWTags.Items.SWORDS, new Supplier[]{ModItems.AMETHYST_SWORD, ModItems.CACTUS_SWORD, ModItems.COPPER_SWORD, ModItems.LEAD_SWORD, ModItems.QUICKSILVER_SWORD, ModItems.SILVER_SWORD, ModItems.TIN_SWORD});
            b.add((Tag<Item>)MWTags.Items.KNIVES, new Supplier[]{ModItems.AMETHYST_KNIFE, ModItems.CACTUS_KNIFE, ModItems.COPPER_KNIFE, ModItems.DIAMOND_KNIFE, ModItems.GOLD_KNIFE, ModItems.IRON_KNIFE, ModItems.LEAD_KNIFE, ModItems.QUICKSILVER_KNIFE, ModItems.SILVER_KNIFE, ModItems.STONE_KNIFE, ModItems.TIN_KNIFE, ModItems.WOODEN_KNIFE});
            b.add((Tag<Item>)MWTags.Items.SILVER_ITEMS, new Supplier[]{ModItems.SILVER_SWORD, ModItems.SILVER_KNIFE, ModItems.SILVER_AXE, ModItems.SILVER_HOE, ModItems.SILVER_PICKAXE, ModItems.SILVER_SHOVEL, ModItems.SILVER_BOOTS, ModItems.SILVER_CHESTPLATE, ModItems.SILVER_HELMET, ModItems.SILVER_LEGGINGS, ModItems.SILVER_SPEAR});
            b.add((Tag<Item>)MWTags.Items.COPPER_ITEMS, new Supplier[]{ModItems.COPPER_SWORD, ModItems.COPPER_KNIFE, ModItems.COPPER_AXE, ModItems.COPPER_HOE, ModItems.COPPER_PICKAXE, ModItems.COPPER_SHOVEL, ModItems.COPPER_BOOTS, ModItems.COPPER_CHESTPLATE, ModItems.COPPER_HELMET, ModItems.COPPER_LEGGINGS, ModItems.COPPER_SPEAR});
            b.add((Tag<Item>)MWTags.Items.QUICKSILVER_ITEMS, new Supplier[]{ModItems.QUICKSILVER_SWORD, ModItems.QUICKSILVER_KNIFE, ModItems.QUICKSILVER_AXE, ModItems.QUICKSILVER_HOE, ModItems.QUICKSILVER_PICKAXE, ModItems.QUICKSILVER_SHOVEL, ModItems.QUICKSILVER_BOOTS, ModItems.QUICKSILVER_CHESTPLATE, ModItems.QUICKSILVER_HELMET, ModItems.QUICKSILVER_LEGGINGS, ModItems.QUICKSILVER_SPEAR});
            b.add((Tag<Item>)MWTags.Items.TIN_ITEMS, new Supplier[]{ModItems.TIN_SWORD, ModItems.TIN_KNIFE, ModItems.TIN_AXE, ModItems.TIN_HOE, ModItems.TIN_PICKAXE, ModItems.TIN_SHOVEL, ModItems.TIN_BOOTS, ModItems.TIN_CHESTPLATE, ModItems.TIN_HELMET, ModItems.TIN_LEGGINGS, ModItems.TIN_SPEAR});
            b.add((Tag<Item>)MWTags.Items.LEAD_ITEMS, new Supplier[]{ModItems.LEAD_SWORD, ModItems.LEAD_KNIFE, ModItems.LEAD_AXE, ModItems.LEAD_HOE, ModItems.LEAD_PICKAXE, ModItems.LEAD_SHOVEL, ModItems.LEAD_BOOTS, ModItems.LEAD_CHESTPLATE, ModItems.LEAD_HELMET, ModItems.LEAD_LEGGINGS, ModItems.LEAD_SPEAR});
            b.copy(MWTags.Blocks.PURPUR, MWTags.Items.PURPUR);
            b.copy(MWTags.Blocks.NETHER_BRICKS, MWTags.Items.NETHER_BRICKS);
            b.copy(MWTags.Blocks.RED_NETHER_BRICKS, MWTags.Items.RED_NETHER_BRICKS);
            b.copy(MWTags.Blocks.TERRACOTTA, MWTags.Items.TERRACOTTA);
        });
        MysticalWorld.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, p -> {
            BlockBuilder b = new BlockBuilder((RegistrateTagsProvider)p);
            b.add((Tag<Block>)MWTags.Blocks.PURPUR, new Block[]{Blocks.field_185767_cT, Blocks.field_185768_cU});
            b.add((Tag<Block>)MWTags.Blocks.NETHER_BRICKS, new Block[]{Blocks.field_196653_dH});
            b.add((Tag<Block>)MWTags.Blocks.RED_NETHER_BRICKS, new Block[]{Blocks.field_196817_hS});
            b.add((Tag<Block>)MWTags.Blocks.TERRACOTTA, new Block[]{Blocks.field_196777_fo, Blocks.field_196778_fp, Blocks.field_196780_fq, Blocks.field_196782_fr, Blocks.field_196783_fs, Blocks.field_196785_ft, Blocks.field_196787_fu, Blocks.field_196789_fv, Blocks.field_196791_fw, Blocks.field_196793_fx, Blocks.field_196795_fy, Blocks.field_196797_fz, Blocks.field_196719_fA, Blocks.field_196720_fB, Blocks.field_196721_fC, Blocks.field_196722_fD, Blocks.field_150405_ch, ModBlocks.TERRACOTTA_BRICK.get()});
        });
    }

    private static class ItemBuilder {
        private RegistrateTagsProvider<Item> provider;

        private ItemBuilder(RegistrateTagsProvider<Item> provider) {
            this.provider = provider;
        }

        private void add(Tag<Item> tag, Supplier<? extends IItemProvider> ... items) {
            this.provider.func_200426_a(tag).func_200573_a((Object[])Stream.of(items).map(Supplier::get).map(IItemProvider::func_199767_j).toArray(Item[]::new)).func_200051_a(tag.func_199886_b());
        }

        private void add(Tag<Item> tag, IItemProvider ... items) {
            this.provider.func_200426_a(tag).func_200573_a((Object[])Stream.of(items).map(IItemProvider::func_199767_j).toArray(Item[]::new)).func_200051_a(tag.func_199886_b());
        }

        private void add(Tag<Item> tag, Tag<Item> tag2) {
            this.provider.func_200426_a(tag).func_200574_a(tag2).func_200051_a(tag.func_199886_b());
        }

        private Additionals<Item> additional(Tag<Item> tag) {
            return o -> this.provider.func_200426_a(tag).add(o).func_200051_a(tag.func_199886_b());
        }

        protected void copy(Tag<Block> from, Tag<Item> to) {
            Tag.Builder<Item> builder = this.provider.func_200426_a(to);
            for (Tag.ITagEntry itagentry : from.func_200570_b()) {
                Tag.ITagEntry<Item> itagentry1 = this.copyEntry((Tag.ITagEntry<Block>)itagentry);
                builder.func_200575_a(itagentry1);
            }
            builder.func_200051_a(to.func_199886_b());
        }

        private Tag.ITagEntry<Item> copyEntry(Tag.ITagEntry<Block> entry) {
            if (entry instanceof Tag.TagEntry) {
                return new Tag.TagEntry(((Tag.TagEntry)entry).func_200577_a());
            }
            if (entry instanceof Tag.ListEntry) {
                ArrayList list = Lists.newArrayList();
                for (Block block : ((Tag.ListEntry)entry).func_200578_a()) {
                    Item item = block.func_199767_j();
                    if (item == Items.field_190931_a) {
                        MysticalWorld.LOG.warn("Itemless block copied to item tag: {}", (Object)ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block));
                        continue;
                    }
                    list.add(item);
                }
                return new Tag.ListEntry((Collection)list);
            }
            throw new UnsupportedOperationException("Unknown tag entry " + entry);
        }
    }

    private static class BlockBuilder {
        private RegistrateTagsProvider<Block> provider;

        private BlockBuilder(RegistrateTagsProvider<Block> provider) {
            this.provider = provider;
        }

        private void add(Tag<Block> tag, Supplier<? extends Block> ... items) {
            this.provider.func_200426_a(tag).func_200573_a((Object[])Stream.of(items).map(Supplier::get).toArray(Block[]::new));
        }

        private void add(Tag<Block> tag, Block ... items) {
            this.provider.func_200426_a(tag).func_200573_a((Object[])items);
        }

        private void add(Tag<Block> tag, Tag<Block> tag2) {
            this.provider.func_200426_a(tag).func_200574_a(tag2);
        }

        private Additionals<Block> additional(Tag<Block> tag) {
            return o -> this.provider.func_200426_a(tag).add(o);
        }
    }

    @FunctionalInterface
    private static interface Additionals<T> {
        public void add(Tag<T> ... var1);
    }
}

