/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.repack.registrate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import epicsquid.mysticalworld.repack.registrate.builders.BlockBuilder;
import epicsquid.mysticalworld.repack.registrate.builders.Builder;
import epicsquid.mysticalworld.repack.registrate.builders.BuilderCallback;
import epicsquid.mysticalworld.repack.registrate.builders.ContainerBuilder;
import epicsquid.mysticalworld.repack.registrate.builders.EntityBuilder;
import epicsquid.mysticalworld.repack.registrate.builders.FluidBuilder;
import epicsquid.mysticalworld.repack.registrate.builders.ItemBuilder;
import epicsquid.mysticalworld.repack.registrate.builders.NoConfigBuilder;
import epicsquid.mysticalworld.repack.registrate.builders.TileEntityBuilder;
import epicsquid.mysticalworld.repack.registrate.providers.ProviderType;
import epicsquid.mysticalworld.repack.registrate.providers.RegistrateDataProvider;
import epicsquid.mysticalworld.repack.registrate.providers.RegistrateProvider;
import epicsquid.mysticalworld.repack.registrate.util.DebugMarkers;
import epicsquid.mysticalworld.repack.registrate.util.LazyValue;
import epicsquid.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullBiFunction;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullConsumer;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullFunction;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullUnaryOperator;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonnullType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class AbstractRegistrate<S extends AbstractRegistrate<S>> {
    private static final Logger log = LogManager.getLogger(AbstractRegistrate.class);
    private final Table<String, Class<?>, Registration<?, ?>> registrations = HashBasedTable.create();
    private final Multimap<Pair<String, Class<?>>, NonNullConsumer<? extends IForgeRegistryEntry<?>>> registerCallbacks = HashMultimap.create();
    private final Table<Pair<String, Class<?>>, ProviderType<?>, Consumer<? extends RegistrateProvider>> datagensByEntry = HashBasedTable.create();
    private final ListMultimap<ProviderType<?>, @NonnullType NonNullConsumer<? extends RegistrateProvider>> datagens = ArrayListMultimap.create();
    private final String modid;
    @Nullable
    private String currentName;
    @Nullable
    private LazyValue<? extends ItemGroup> currentGroup;
    private boolean skipErrors;
    private final LazyValue<List<Pair<String, String>>> extraLang = new LazyValue<List>(() -> {
        ArrayList ret = new ArrayList();
        this.addDataGenerator(ProviderType.LANG, prov -> ret.forEach(p -> prov.add((String)p.getKey(), (String)p.getValue())));
        return ret;
    });

    public static boolean isDevEnvironment() {
        return FMLEnvironment.naming.equals("mcp");
    }

    protected AbstractRegistrate(String modid) {
        this.modid = modid;
    }

    protected S self() {
        return (S)this;
    }

    protected S registerEventListeners(IEventBus bus) {
        bus.addListener(this::onRegister);
        bus.addListener(this::onData);
        return this.self();
    }

    @SubscribeEvent
    protected void onRegister(RegistryEvent.Register<?> event) {
        Map registrationsForType;
        Class type = event.getRegistry().getRegistrySuperType();
        if (type == null) {
            log.debug(DebugMarkers.REGISTER, "Skipping invalid registry with no supertype: " + event.getRegistry().getRegistryName());
            return;
        }
        if (!this.registerCallbacks.isEmpty()) {
            this.registerCallbacks.asMap().forEach((k, v) -> log.warn("Found {} unused register callback(s) for entry {} [{}]. Was the entry ever registered?", (Object)v.size(), k.getLeft(), (Object)((Class)k.getRight()).getSimpleName()));
            if (AbstractRegistrate.isDevEnvironment()) {
                throw new IllegalStateException("Found unused register callbacks, see logs");
            }
        }
        if ((registrationsForType = this.registrations.column((Object)type)).size() > 0) {
            log.debug(DebugMarkers.REGISTER, "Registering {} known objects of type {}", (Object)registrationsForType.size(), (Object)type.getName());
            for (Map.Entry e : registrationsForType.entrySet()) {
                try {
                    ((Registration)e.getValue()).register(event.getRegistry());
                    log.debug(DebugMarkers.REGISTER, "Registered {} to registry {}", (Object)((Registration)e.getValue()).getName(), (Object)event.getRegistry().getRegistryName());
                }
                catch (Exception ex) {
                    String err = "Unexpected error while registering entry " + ((Registration)e.getValue()).getName() + " to registry " + event.getRegistry().getRegistryName();
                    if (this.skipErrors) {
                        log.error(DebugMarkers.REGISTER, err);
                        continue;
                    }
                    throw new RuntimeException(err, ex);
                }
            }
        }
    }

    protected void onData(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new RegistrateDataProvider(this, this.modid, event));
    }

    protected String currentName() {
        String name = this.currentName;
        Objects.requireNonNull(name, "Current name not set");
        return name;
    }

    public <R extends IForgeRegistryEntry<R>, T extends R> RegistryEntry<T> get(Class<? super R> type) {
        return this.get(this.currentName(), type);
    }

    public <R extends IForgeRegistryEntry<R>, T extends R> RegistryEntry<T> get(String name, Class<? super R> type) {
        return this.getRegistration(name, type).getDelegate();
    }

    @Nullable
    private <R extends IForgeRegistryEntry<R>, T extends R> Registration<R, T> getRegistrationUnchecked(String name, Class<? super R> type) {
        return (Registration)this.registrations.get((Object)name, type);
    }

    private <R extends IForgeRegistryEntry<R>, T extends R> Registration<R, T> getRegistration(String name, Class<? super R> type) {
        Registration<? super R, T> reg = this.getRegistrationUnchecked(name, type);
        if (reg != null) {
            return reg;
        }
        throw new IllegalArgumentException("Unknown registration " + name + " for type " + type);
    }

    public <R extends IForgeRegistryEntry<R>> Collection<RegistryEntry<R>> getAll(Class<? super R> type) {
        return this.registrations.column(type).values().stream().map(r -> r.getDelegate()).collect(Collectors.toList());
    }

    public <R extends IForgeRegistryEntry<R>, T extends R> S addRegisterCallback(String name, Class<? super R> registryType, NonNullConsumer<? super T> callback) {
        Registration<R, ? super T> reg = this.getRegistrationUnchecked(name, registryType);
        if (reg == null) {
            this.registerCallbacks.put((Object)Pair.of((Object)name, registryType), callback);
        } else {
            reg.addRegisterCallback(callback);
        }
        return this.self();
    }

    public <P extends RegistrateProvider, R extends IForgeRegistryEntry<R>> S setDataGenerator(Builder<R, ?, ?, ?> builder, ProviderType<P> type, NonNullConsumer<? extends P> cons) {
        return this.setDataGenerator(builder.getName(), builder.getRegistryType(), type, cons);
    }

    public <P extends RegistrateProvider, R extends IForgeRegistryEntry<R>> S setDataGenerator(String entry, Class<? super R> registryType, ProviderType<P> type, NonNullConsumer<? extends P> cons) {
        Consumer existing = (Consumer)this.datagensByEntry.put((Object)Pair.of((Object)entry, registryType), type, cons);
        if (existing != null) {
            this.datagens.remove(type, (Object)existing);
        }
        return this.addDataGenerator(type, cons);
    }

    public <T extends RegistrateProvider> S addDataGenerator(ProviderType<T> type, NonNullConsumer<? extends T> cons) {
        this.datagens.put(type, cons);
        return this.self();
    }

    @Deprecated
    public TranslationTextComponent addLang(String key, String value) {
        String prefixedKey = this.getModid() + "." + key;
        this.addDataGenerator(ProviderType.LANG, p -> p.add(prefixedKey, value));
        return new TranslationTextComponent(prefixedKey, new Object[0]);
    }

    public TranslationTextComponent addLang(String type, ResourceLocation id, String localizedName) {
        return this.addRawLang(Util.func_200697_a((String)type, (ResourceLocation)id), localizedName);
    }

    public TranslationTextComponent addLang(String type, ResourceLocation id, String suffix, String localizedName) {
        return this.addRawLang(Util.func_200697_a((String)type, (ResourceLocation)id) + "." + suffix, localizedName);
    }

    public TranslationTextComponent addRawLang(String key, String value) {
        this.extraLang.get().add((Pair<String, String>)Pair.of((Object)key, (Object)value));
        return new TranslationTextComponent(key, new Object[0]);
    }

    private Optional<Pair<String, Class<?>>> getEntryForGenerator(ProviderType<?> type, NonNullConsumer<? extends RegistrateProvider> generator) {
        for (Map.Entry e : this.datagensByEntry.column(type).entrySet()) {
            if (e.getValue() != generator) continue;
            return Optional.of(e.getKey());
        }
        return Optional.empty();
    }

    public <T extends RegistrateProvider> void genData(ProviderType<T> type, T gen) {
        this.datagens.get(type).forEach(cons -> {
            Optional<Pair<String, Class<?>>> entry = null;
            if (log.isEnabled(Level.DEBUG, DebugMarkers.DATA)) {
                entry = this.getEntryForGenerator(type, (NonNullConsumer<? extends RegistrateProvider>)cons);
                if (entry.isPresent()) {
                    log.debug(DebugMarkers.DATA, "Generating data of type {} for entry {} [{}]", (Object)RegistrateDataProvider.getTypeName(type), entry.get().getLeft(), (Object)((Class)entry.get().getRight()).getSimpleName());
                } else {
                    log.debug(DebugMarkers.DATA, "Generating unassociated data of type {} ({})", (Object)RegistrateDataProvider.getTypeName(type), (Object)type);
                }
            }
            try {
                cons.accept(gen);
            }
            catch (Exception e) {
                if (entry == null) {
                    entry = this.getEntryForGenerator(type, (NonNullConsumer<? extends RegistrateProvider>)cons);
                }
                Message err = entry.isPresent() ? log.getMessageFactory().newMessage("Unexpected error while running data generator of type {} for entry {} [{}]", new Object[]{RegistrateDataProvider.getTypeName(type), entry.get().getLeft(), ((Class)entry.get().getRight()).getSimpleName()}) : log.getMessageFactory().newMessage("Unexpected error while running unassociated data generator of type {} ({})", new Object[]{RegistrateDataProvider.getTypeName(type), type});
                if (this.skipErrors) {
                    log.error(err);
                }
                throw new RuntimeException(err.getFormattedMessage(), e);
            }
        });
    }

    public S skipErrors(boolean skipErrors) {
        if (skipErrors && !AbstractRegistrate.isDevEnvironment()) {
            log.error("Ignoring skipErrors(true) as this is not a development environment!");
        } else {
            this.skipErrors = skipErrors;
        }
        return this.self();
    }

    public S object(String name) {
        this.currentName = name;
        return this.self();
    }

    public S itemGroup(NonNullSupplier<? extends ItemGroup> group) {
        this.currentGroup = new LazyValue<ItemGroup>(group);
        return this.self();
    }

    public S itemGroup(NonNullSupplier<? extends ItemGroup> group, String localizedName) {
        this.addDataGenerator(ProviderType.LANG, prov -> prov.add((ItemGroup)group.get(), localizedName));
        return this.itemGroup(group);
    }

    public S transform(NonNullUnaryOperator<S> func) {
        return (S)((AbstractRegistrate)func.apply(this.self()));
    }

    public <R extends IForgeRegistryEntry<R>, T extends R, P, S2 extends Builder<R, T, P, S2>> S2 transform(NonNullFunction<S, S2> func) {
        return (S2)((Builder)func.apply(this.self()));
    }

    public <R extends IForgeRegistryEntry<R>, T extends R, P, S2 extends Builder<R, T, P, S2>> S2 entry(NonNullBiFunction<String, BuilderCallback, S2> factory) {
        return (S2)this.entry(this.currentName(), callback -> (Builder)factory.apply(this.currentName(), (BuilderCallback)callback));
    }

    public <R extends IForgeRegistryEntry<R>, T extends R, P, S2 extends Builder<R, T, P, S2>> S2 entry(String name, NonNullFunction<BuilderCallback, S2> factory) {
        return (S2)((Builder)factory.apply(this::accept));
    }

    protected <R extends IForgeRegistryEntry<R>, T extends R> RegistryEntry<T> accept(String name, Class<? super R> type, Builder<R, T, ?, ?> builder, NonNullSupplier<? extends T> creator, NonNullFunction<RegistryObject<T>, ? extends RegistryEntry<T>> entryFactory) {
        Registration reg = new Registration(new ResourceLocation(this.modid, name), type, builder, creator, entryFactory);
        log.debug(DebugMarkers.REGISTER, "Captured registration for entry {} of type {}", (Object)name, (Object)type.getName());
        this.registerCallbacks.removeAll((Object)Pair.of((Object)name, type)).forEach(callback -> {
            NonNullConsumer unsafeCallback = callback;
            reg.addRegisterCallback(unsafeCallback);
        });
        this.registrations.put((Object)name, type, reg);
        return reg.getDelegate();
    }

    public <R extends IForgeRegistryEntry<R>, T extends R> RegistryEntry<T> simple(Class<? super R> registryType, NonNullSupplier<T> factory) {
        return this.simple((Object)this.currentName(), registryType, factory);
    }

    public <R extends IForgeRegistryEntry<R>, T extends R> RegistryEntry<T> simple(String name, Class<? super R> registryType, NonNullSupplier<T> factory) {
        return this.simple(this, name, registryType, factory);
    }

    public <R extends IForgeRegistryEntry<R>, T extends R, P> RegistryEntry<T> simple(P parent, Class<? super R> registryType, NonNullSupplier<T> factory) {
        return this.simple(parent, this.currentName(), registryType, factory);
    }

    public <R extends IForgeRegistryEntry<R>, T extends R, P> RegistryEntry<T> simple(P parent, String name, Class<? super R> registryType, NonNullSupplier<T> factory) {
        return this.entry(name, callback -> new NoConfigBuilder(this, parent, name, (BuilderCallback)callback, registryType, factory)).register();
    }

    public <T extends Item> ItemBuilder<T, S> item(NonNullFunction<Item.Properties, T> factory) {
        return this.item(this.self(), factory);
    }

    public <T extends Item> ItemBuilder<T, S> item(String name, NonNullFunction<Item.Properties, T> factory) {
        return this.item(this.self(), name, factory);
    }

    public <T extends Item, P> ItemBuilder<T, P> item(P parent, NonNullFunction<Item.Properties, T> factory) {
        return this.item(parent, this.currentName(), factory);
    }

    public <T extends Item, P> ItemBuilder<T, P> item(P parent, String name, NonNullFunction<Item.Properties, T> factory) {
        return this.entry(name, callback -> ItemBuilder.create(this, parent, name, callback, factory, this.currentGroup));
    }

    public <T extends Block> BlockBuilder<T, S> block(NonNullFunction<Block.Properties, T> factory) {
        return this.block(this.self(), factory);
    }

    public <T extends Block> BlockBuilder<T, S> block(String name, NonNullFunction<Block.Properties, T> factory) {
        return this.block(this.self(), name, factory);
    }

    public <T extends Block, P> BlockBuilder<T, P> block(P parent, NonNullFunction<Block.Properties, T> factory) {
        return this.block(parent, this.currentName(), factory);
    }

    public <T extends Block, P> BlockBuilder<T, P> block(P parent, String name, NonNullFunction<Block.Properties, T> factory) {
        return this.block(parent, name, Material.field_151576_e, factory);
    }

    public <T extends Block> BlockBuilder<T, S> block(Material material, NonNullFunction<Block.Properties, T> factory) {
        return this.block(this.self(), material, factory);
    }

    public <T extends Block> BlockBuilder<T, S> block(String name, Material material, NonNullFunction<Block.Properties, T> factory) {
        return this.block(this.self(), name, material, factory);
    }

    public <T extends Block, P> BlockBuilder<T, P> block(P parent, Material material, NonNullFunction<Block.Properties, T> factory) {
        return this.block(parent, this.currentName(), material, factory);
    }

    public <T extends Block, P> BlockBuilder<T, P> block(P parent, String name, Material material, NonNullFunction<Block.Properties, T> factory) {
        return this.entry(name, callback -> BlockBuilder.create(this, parent, name, callback, factory, material));
    }

    public <T extends Entity> EntityBuilder<T, S> entity(EntityType.IFactory<T> factory, EntityClassification classification) {
        return this.entity(this.self(), factory, classification);
    }

    public <T extends Entity> EntityBuilder<T, S> entity(String name, EntityType.IFactory<T> factory, EntityClassification classification) {
        return this.entity(this.self(), name, factory, classification);
    }

    public <T extends Entity, P> EntityBuilder<T, P> entity(P parent, EntityType.IFactory<T> factory, EntityClassification classification) {
        return this.entity(parent, this.currentName(), factory, classification);
    }

    public <T extends Entity, P> EntityBuilder<T, P> entity(P parent, String name, EntityType.IFactory<T> factory, EntityClassification classification) {
        return this.entry(name, callback -> EntityBuilder.create(this, parent, name, callback, factory, classification));
    }

    public <T extends TileEntity> TileEntityBuilder<T, S> tileEntity(NonNullSupplier<? extends T> factory) {
        return this.tileEntity(this.self(), factory);
    }

    public <T extends TileEntity> TileEntityBuilder<T, S> tileEntity(String name, NonNullSupplier<? extends T> factory) {
        return this.tileEntity(this.self(), name, factory);
    }

    public <T extends TileEntity, P> TileEntityBuilder<T, P> tileEntity(P parent, NonNullSupplier<? extends T> factory) {
        return this.tileEntity(parent, this.currentName(), factory);
    }

    public <T extends TileEntity, P> TileEntityBuilder<T, P> tileEntity(P parent, String name, NonNullSupplier<? extends T> factory) {
        return this.entry(name, callback -> TileEntityBuilder.create(this, parent, name, callback, factory));
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid() {
        return this.fluid(this.self());
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return this.fluid(this.self(), stillTexture, flowingTexture);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory) {
        return this.fluid(this.self(), stillTexture, flowingTexture, attributesFactory);
    }

    public <T extends ForgeFlowingFluid> FluidBuilder<T, S> fluid(ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return this.fluid(this.self(), stillTexture, flowingTexture, factory);
    }

    public <T extends ForgeFlowingFluid> FluidBuilder<T, S> fluid(ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return this.fluid(this.self(), stillTexture, flowingTexture, attributesFactory, factory);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(String name) {
        return this.fluid(this.self(), name);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture, attributesFactory);
    }

    public <T extends ForgeFlowingFluid> FluidBuilder<T, S> fluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture, factory);
    }

    public <T extends ForgeFlowingFluid> FluidBuilder<T, S> fluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture, attributesFactory, factory);
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent) {
        return this.fluid(parent, this.currentName());
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture);
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture, attributesFactory);
    }

    public <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> fluid(P parent, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture, factory);
    }

    public <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> fluid(P parent, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture, attributesFactory, factory);
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, String name) {
        return this.fluid(parent, name, new ResourceLocation(this.getModid(), "block/" + this.currentName() + "_still"), new ResourceLocation(this.getModid(), "block/" + this.currentName() + "_flow"));
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, String name, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture));
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture, attributesFactory));
    }

    public <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> fluid(P parent, String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture, factory));
    }

    public <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> fluid(P parent, String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture, attributesFactory, factory));
    }

    public <T extends Container, SC extends Screen> ContainerBuilder<T, SC, S> container(ContainerBuilder.ContainerFactory<T> factory, NonNullSupplier<ContainerBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.container((Object)this.currentName(), factory, screenFactory);
    }

    public <T extends Container, SC extends Screen> ContainerBuilder<T, SC, S> container(String name, ContainerBuilder.ContainerFactory<T> factory, NonNullSupplier<ContainerBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.container(this.self(), name, factory, screenFactory);
    }

    public <T extends Container, SC extends Screen, P> ContainerBuilder<T, SC, P> container(P parent, ContainerBuilder.ContainerFactory<T> factory, NonNullSupplier<ContainerBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.container(parent, this.currentName(), factory, screenFactory);
    }

    public <T extends Container, SC extends Screen, P> ContainerBuilder<T, SC, P> container(P parent, String name, ContainerBuilder.ContainerFactory<T> factory, NonNullSupplier<ContainerBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.entry(name, callback -> new ContainerBuilder(this, parent, name, (BuilderCallback)callback, factory, screenFactory));
    }

    public String getModid() {
        return this.modid;
    }

    private final class Registration<R extends IForgeRegistryEntry<R>, T extends R> {
        private final ResourceLocation name;
        private final Class<? super R> type;
        private final Builder<R, T, ?, ?> builder;
        private final Supplier<? extends T> creator;
        private final RegistryEntry<T> delegate;
        private final List<NonNullConsumer<? super T>> callbacks = new ArrayList<NonNullConsumer<? super T>>();

        Registration(ResourceLocation name, Class<? super R> type, Builder<R, T, ?, ?> builder, Supplier<? extends T> creator, NonNullFunction<RegistryObject<T>, ? extends RegistryEntry<T>> entryFactory) {
            this.name = name;
            this.type = type;
            this.builder = builder;
            this.creator = creator;
            this.delegate = entryFactory.apply(RegistryObject.of((ResourceLocation)name, (IForgeRegistry)RegistryManager.ACTIVE.getRegistry(type)));
        }

        void register(IForgeRegistry<R> registry) {
            IForgeRegistryEntry entry = (IForgeRegistryEntry)this.creator.get();
            registry.register((IForgeRegistryEntry)entry.setRegistryName(this.name));
            this.delegate.updateReference(registry);
            this.callbacks.forEach(c -> c.accept(entry));
        }

        void addRegisterCallback(NonNullConsumer<? super T> callback) {
            Preconditions.checkNotNull(callback, (Object)"Callback must not be null");
            this.callbacks.add(callback);
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public Class<? super R> getType() {
            return this.type;
        }

        public Builder<R, T, ?, ?> getBuilder() {
            return this.builder;
        }

        public Supplier<? extends T> getCreator() {
            return this.creator;
        }

        public RegistryEntry<T> getDelegate() {
            return this.delegate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Registration)) {
                return false;
            }
            Registration other = (Registration)o;
            ResourceLocation this$name = this.getName();
            ResourceLocation other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Class<R> this$type = this.getType();
            Class<R> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Builder<R, T, ?, ?> this$builder = this.getBuilder();
            Builder<R, T, ?, ?> other$builder = other.getBuilder();
            if (this$builder == null ? other$builder != null : !this$builder.equals(other$builder)) {
                return false;
            }
            Supplier<T> this$creator = this.getCreator();
            Supplier<T> other$creator = other.getCreator();
            if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
                return false;
            }
            RegistryEntry<T> this$delegate = this.getDelegate();
            RegistryEntry<T> other$delegate = other.getDelegate();
            if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
                return false;
            }
            List<NonNullConsumer<T>> this$callbacks = this.callbacks;
            List<NonNullConsumer<? super T>> other$callbacks = other.callbacks;
            return !(this$callbacks == null ? other$callbacks != null : !((Object)this$callbacks).equals(other$callbacks));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ResourceLocation $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Class<R> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Builder<R, T, ?, ?> $builder = this.getBuilder();
            result = result * 59 + ($builder == null ? 43 : $builder.hashCode());
            Supplier<T> $creator = this.getCreator();
            result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
            RegistryEntry<T> $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
            List<NonNullConsumer<T>> $callbacks = this.callbacks;
            result = result * 59 + ($callbacks == null ? 43 : ((Object)$callbacks).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractRegistrate.Registration(name=" + this.getName() + ", type=" + this.getType() + ", builder=" + this.getBuilder() + ", creator=" + this.getCreator() + ", delegate=" + this.getDelegate() + ", callbacks=" + this.callbacks + ")";
        }
    }
}

