/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.repack.registrate.builders;

import epicsquid.mysticalworld.repack.registrate.AbstractRegistrate;
import epicsquid.mysticalworld.repack.registrate.builders.AbstractBuilder;
import epicsquid.mysticalworld.repack.registrate.builders.BuilderCallback;
import epicsquid.mysticalworld.repack.registrate.providers.DataGenContext;
import epicsquid.mysticalworld.repack.registrate.providers.ProviderType;
import epicsquid.mysticalworld.repack.registrate.providers.RegistrateItemModelProvider;
import epicsquid.mysticalworld.repack.registrate.providers.RegistrateRecipeProvider;
import epicsquid.mysticalworld.repack.registrate.util.entry.ItemEntry;
import epicsquid.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullBiConsumer;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullFunction;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tags.Tag;
import net.minecraftforge.fml.RegistryObject;

public class ItemBuilder<T extends Item, P>
extends AbstractBuilder<Item, T, P, ItemBuilder<T, P>> {
    private final NonNullFunction<Item.Properties, T> factory;
    private final NonNullSupplier<Item.Properties> properties = Item.Properties::new;
    private NonNullFunction<Item.Properties, Item.Properties> propertiesCallback = NonNullUnaryOperator.identity();

    public static <T extends Item, P> ItemBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory) {
        return ItemBuilder.create(owner, parent, name, callback, factory, null);
    }

    public static <T extends Item, P> ItemBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory, @Nullable NonNullSupplier<? extends ItemGroup> group) {
        return new ItemBuilder<T, P>(owner, parent, name, callback, factory).defaultModel().defaultLang().transform(ib -> group == null ? ib : ib.group(group));
    }

    protected ItemBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory) {
        super(owner, parent, name, callback, Item.class);
        this.factory = factory;
    }

    public ItemBuilder<T, P> properties(NonNullUnaryOperator<Item.Properties> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public ItemBuilder<T, P> group(NonNullSupplier<? extends ItemGroup> group) {
        return this.properties(p -> p.func_200916_a((ItemGroup)group.get()));
    }

    public ItemBuilder<T, P> defaultModel() {
        return this.model((ctx, prov) -> prov.generated(ctx::getEntry));
    }

    public ItemBuilder<T, P> model(NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.ITEM_MODEL, cons);
    }

    public ItemBuilder<T, P> defaultLang() {
        return (ItemBuilder)this.lang(Item::func_77658_a);
    }

    public ItemBuilder<T, P> lang(String name) {
        return (ItemBuilder)this.lang(Item::func_77658_a, name);
    }

    public ItemBuilder<T, P> recipe(NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    public ItemBuilder<T, P> tag(Tag<Item> tag) {
        return (ItemBuilder)this.tag(ProviderType.ITEM_TAGS, tag);
    }

    @Override
    protected T createEntry() {
        Item.Properties properties = this.properties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Item)this.factory.apply(properties));
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new ItemEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public ItemEntry<T> register() {
        return (ItemEntry)super.register();
    }
}

