/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.repack.registrate.providers;

import epicsquid.mysticalworld.repack.registrate.AbstractRegistrate;
import epicsquid.mysticalworld.repack.registrate.providers.ProviderType;
import epicsquid.mysticalworld.repack.registrate.providers.RegistrateProvider;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.LogicalSide;

public class RegistrateItemModelProvider
extends ItemModelProvider
implements RegistrateProvider {
    private final AbstractRegistrate<?> parent;

    public RegistrateItemModelProvider(AbstractRegistrate<?> parent, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, parent.getModid(), existingFileHelper);
        this.parent = parent;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.CLIENT;
    }

    protected void registerModels() {
        this.parent.genData(ProviderType.ITEM_MODEL, this);
    }

    public String func_200397_b() {
        return "Item models";
    }

    public String modid(NonNullSupplier<? extends IItemProvider> item) {
        return item.get().func_199767_j().getRegistryName().func_110624_b();
    }

    public String name(NonNullSupplier<? extends IItemProvider> item) {
        return item.get().func_199767_j().getRegistryName().func_110623_a();
    }

    public ResourceLocation itemTexture(NonNullSupplier<? extends IItemProvider> item) {
        return this.modLoc("item/" + this.name(item));
    }

    public ItemModelBuilder blockItem(NonNullSupplier<? extends IItemProvider> block) {
        return this.blockItem(block, "");
    }

    public ItemModelBuilder blockItem(NonNullSupplier<? extends IItemProvider> block, String suffix) {
        return this.withExistingParent(this.name(block), new ResourceLocation(this.modid(block), "block/" + this.name(block) + suffix));
    }

    public ItemModelBuilder blockWithInventoryModel(NonNullSupplier<? extends IItemProvider> block) {
        return this.withExistingParent(this.name(block), new ResourceLocation(this.modid(block), "block/" + this.name(block) + "_inventory"));
    }

    public ItemModelBuilder blockSprite(NonNullSupplier<? extends IItemProvider> block) {
        return this.blockSprite(block, this.modLoc("block/" + this.name(block)));
    }

    public ItemModelBuilder blockSprite(NonNullSupplier<? extends IItemProvider> block, ResourceLocation texture) {
        return this.generated(() -> ((IItemProvider)block.get()).func_199767_j(), texture);
    }

    public ItemModelBuilder generated(NonNullSupplier<? extends IItemProvider> item) {
        return this.generated(item, this.itemTexture(item));
    }

    public ItemModelBuilder generated(NonNullSupplier<? extends IItemProvider> item, ResourceLocation ... layers) {
        ItemModelBuilder ret = (ItemModelBuilder)this.getBuilder(this.name(item)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        for (int i = 0; i < layers.length; ++i) {
            ret = (ItemModelBuilder)ret.texture("layer" + i, layers[i]);
        }
        return ret;
    }

    public ItemModelBuilder handheld(NonNullSupplier<? extends IItemProvider> item) {
        return this.handheld(item, this.itemTexture(item));
    }

    public ItemModelBuilder handheld(NonNullSupplier<? extends IItemProvider> item, ResourceLocation texture) {
        return (ItemModelBuilder)this.withExistingParent(this.name(item), "item/handheld").texture("layer0", texture);
    }

    public ItemModelBuilder getBuilder(String path) {
        return (ItemModelBuilder)super.getBuilder(path);
    }

    public ResourceLocation modLoc(String name) {
        return super.modLoc(name);
    }

    public ResourceLocation mcLoc(String name) {
        return super.mcLoc(name);
    }

    public ItemModelBuilder withExistingParent(String name, String parent) {
        return (ItemModelBuilder)super.withExistingParent(name, parent);
    }

    public ItemModelBuilder withExistingParent(String name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(name, parent);
    }

    public ItemModelBuilder cube(String name, ResourceLocation down, ResourceLocation up, ResourceLocation north, ResourceLocation south, ResourceLocation east, ResourceLocation west) {
        return (ItemModelBuilder)super.cube(name, down, up, north, south, east, west);
    }

    public ItemModelBuilder singleTexture(String name, ResourceLocation parent, ResourceLocation texture) {
        return (ItemModelBuilder)super.singleTexture(name, parent, texture);
    }

    public ItemModelBuilder singleTexture(String name, ResourceLocation parent, String textureKey, ResourceLocation texture) {
        return (ItemModelBuilder)super.singleTexture(name, parent, textureKey, texture);
    }

    public ItemModelBuilder cubeAll(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.cubeAll(name, texture);
    }

    public ItemModelBuilder cubeTop(String name, ResourceLocation side, ResourceLocation top) {
        return (ItemModelBuilder)super.cubeTop(name, side, top);
    }

    public ItemModelBuilder cubeBottomTop(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return (ItemModelBuilder)super.cubeBottomTop(name, side, bottom, top);
    }

    public ItemModelBuilder cubeColumn(String name, ResourceLocation side, ResourceLocation end) {
        return (ItemModelBuilder)super.cubeColumn(name, side, end);
    }

    public ItemModelBuilder orientableVertical(String name, ResourceLocation side, ResourceLocation front) {
        return (ItemModelBuilder)super.orientableVertical(name, side, front);
    }

    public ItemModelBuilder orientableWithBottom(String name, ResourceLocation side, ResourceLocation front, ResourceLocation bottom, ResourceLocation top) {
        return (ItemModelBuilder)super.orientableWithBottom(name, side, front, bottom, top);
    }

    public ItemModelBuilder orientable(String name, ResourceLocation side, ResourceLocation front, ResourceLocation top) {
        return (ItemModelBuilder)super.orientable(name, side, front, top);
    }

    public ItemModelBuilder crop(String name, ResourceLocation crop) {
        return (ItemModelBuilder)super.crop(name, crop);
    }

    public ItemModelBuilder cross(String name, ResourceLocation cross) {
        return (ItemModelBuilder)super.cross(name, cross);
    }

    public ItemModelBuilder stairs(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return (ItemModelBuilder)super.stairs(name, side, bottom, top);
    }

    public ItemModelBuilder stairsOuter(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return (ItemModelBuilder)super.stairsOuter(name, side, bottom, top);
    }

    public ItemModelBuilder stairsInner(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return (ItemModelBuilder)super.stairsInner(name, side, bottom, top);
    }

    public ItemModelBuilder slab(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return (ItemModelBuilder)super.slab(name, side, bottom, top);
    }

    public ItemModelBuilder slabTop(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        return (ItemModelBuilder)super.slabTop(name, side, bottom, top);
    }

    public ItemModelBuilder fencePost(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.fencePost(name, texture);
    }

    public ItemModelBuilder fenceSide(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.fenceSide(name, texture);
    }

    public ItemModelBuilder fenceInventory(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.fenceInventory(name, texture);
    }

    public ItemModelBuilder fenceGate(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.fenceGate(name, texture);
    }

    public ItemModelBuilder fenceGateOpen(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.fenceGateOpen(name, texture);
    }

    public ItemModelBuilder fenceGateWall(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.fenceGateWall(name, texture);
    }

    public ItemModelBuilder fenceGateWallOpen(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.fenceGateWallOpen(name, texture);
    }

    public ItemModelBuilder wallPost(String name, ResourceLocation wall) {
        return (ItemModelBuilder)super.wallPost(name, wall);
    }

    public ItemModelBuilder wallSide(String name, ResourceLocation wall) {
        return (ItemModelBuilder)super.wallSide(name, wall);
    }

    public ItemModelBuilder wallInventory(String name, ResourceLocation wall) {
        return (ItemModelBuilder)super.wallInventory(name, wall);
    }

    public ItemModelBuilder panePost(String name, ResourceLocation pane, ResourceLocation edge) {
        return (ItemModelBuilder)super.panePost(name, pane, edge);
    }

    public ItemModelBuilder paneSide(String name, ResourceLocation pane, ResourceLocation edge) {
        return (ItemModelBuilder)super.paneSide(name, pane, edge);
    }

    public ItemModelBuilder paneSideAlt(String name, ResourceLocation pane, ResourceLocation edge) {
        return (ItemModelBuilder)super.paneSideAlt(name, pane, edge);
    }

    public ItemModelBuilder paneNoSide(String name, ResourceLocation pane) {
        return (ItemModelBuilder)super.paneNoSide(name, pane);
    }

    public ItemModelBuilder paneNoSideAlt(String name, ResourceLocation pane) {
        return (ItemModelBuilder)super.paneNoSideAlt(name, pane);
    }

    public ItemModelBuilder doorBottomLeft(String name, ResourceLocation bottom, ResourceLocation top) {
        return (ItemModelBuilder)super.doorBottomLeft(name, bottom, top);
    }

    public ItemModelBuilder doorBottomRight(String name, ResourceLocation bottom, ResourceLocation top) {
        return (ItemModelBuilder)super.doorBottomRight(name, bottom, top);
    }

    public ItemModelBuilder doorTopLeft(String name, ResourceLocation bottom, ResourceLocation top) {
        return (ItemModelBuilder)super.doorTopLeft(name, bottom, top);
    }

    public ItemModelBuilder doorTopRight(String name, ResourceLocation bottom, ResourceLocation top) {
        return (ItemModelBuilder)super.doorTopRight(name, bottom, top);
    }

    public ItemModelBuilder trapdoorBottom(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.trapdoorBottom(name, texture);
    }

    public ItemModelBuilder trapdoorTop(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.trapdoorTop(name, texture);
    }

    public ItemModelBuilder trapdoorOpen(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.trapdoorOpen(name, texture);
    }

    public ItemModelBuilder trapdoorOrientableBottom(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.trapdoorOrientableBottom(name, texture);
    }

    public ItemModelBuilder trapdoorOrientableTop(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.trapdoorOrientableTop(name, texture);
    }

    public ItemModelBuilder trapdoorOrientableOpen(String name, ResourceLocation texture) {
        return (ItemModelBuilder)super.trapdoorOrientableOpen(name, texture);
    }

    public ItemModelBuilder torch(String name, ResourceLocation torch) {
        return (ItemModelBuilder)super.torch(name, torch);
    }

    public ItemModelBuilder torchWall(String name, ResourceLocation torch) {
        return (ItemModelBuilder)super.torchWall(name, torch);
    }

    public ItemModelBuilder carpet(String name, ResourceLocation wool) {
        return (ItemModelBuilder)super.carpet(name, wool);
    }
}

