/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.repack.registrate.util.entry;

import epicsquid.mysticalworld.repack.registrate.AbstractRegistrate;
import epicsquid.mysticalworld.repack.registrate.Registrate;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonnullType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryEntry<T extends IForgeRegistryEntry<? super T>>
implements NonNullSupplier<T> {
    private static RegistryEntry<?> EMPTY = new RegistryEntry(new Registrate("dummy"){}, null);
    private final AbstractRegistrate<?> owner;
    @Nullable
    private final RegistryObject<T> delegate;

    private static <T extends IForgeRegistryEntry<? super T>> RegistryEntry<T> empty() {
        RegistryEntry<?> t = EMPTY;
        return t;
    }

    public RegistryEntry(AbstractRegistrate<?> owner, RegistryObject<T> delegate) {
        if (EMPTY != null && delegate == null) {
            throw new NullPointerException("Delegate must not be null");
        }
        this.owner = owner;
        this.delegate = delegate;
    }

    public void updateReference(IForgeRegistry<? super T> registry) {
        RegistryObject<T> delegate = this.delegate;
        Objects.requireNonNull(delegate, "Registry entry is empty").updateReference(registry);
    }

    @Override
    @NonnullType
    public T get() {
        RegistryObject delegate = this.delegate;
        return (T)((IForgeRegistryEntry)Objects.requireNonNull(this.getUnchecked(), () -> delegate == null ? "Registry entry is empty" : "Registry entry not present: " + delegate.getId()));
    }

    @Nullable
    public T getUnchecked() {
        RegistryObject<T> delegate = this.delegate;
        return (T)(delegate == null ? null : delegate.get());
    }

    public <R extends IForgeRegistryEntry<R>, E extends R> RegistryEntry<E> getSibling(Class<? super R> registryType) {
        return this.owner.get(this.getId().func_110623_a(), registryType);
    }

    public <R extends IForgeRegistryEntry<R>, E extends R> RegistryEntry<E> getSibling(IForgeRegistry<R> registry) {
        return this.getSibling(registry.getRegistrySuperType());
    }

    public RegistryEntry<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent() || predicate.test(this.get())) {
            return this;
        }
        return RegistryEntry.empty();
    }

    public ResourceLocation getId() {
        return this.delegate.getId();
    }

    @Deprecated
    public String getName() {
        return this.delegate.getName();
    }

    public Stream<T> stream() {
        return this.delegate.stream();
    }

    public boolean isPresent() {
        return this.delegate.isPresent();
    }

    public void ifPresent(Consumer<? super T> consumer) {
        this.delegate.ifPresent(consumer);
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        return this.delegate.map(mapper);
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        return this.delegate.flatMap(mapper);
    }

    public <U> Supplier<U> lazyMap(Function<? super T, ? extends U> mapper) {
        return this.delegate.lazyMap(mapper);
    }

    public T orElse(T other) {
        return (T)this.delegate.orElse(other);
    }

    public T orElseGet(Supplier<? extends T> other) {
        return (T)this.delegate.orElseGet(other);
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return (T)this.delegate.orElseThrow(exceptionSupplier);
    }

    private static interface Exclusions<T extends IForgeRegistryEntry<? super T>> {
        public T get();

        public RegistryObject<T> filter(Predicate<? super T> var1);

        public void updateReference(IForgeRegistry<? extends T> var1);
    }
}

