/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.setup;

import com.google.common.collect.Sets;
import epicsquid.mysticalworld.MysticalWorld;
import epicsquid.mysticalworld.api.IPlayerShoulderCapability;
import epicsquid.mysticalworld.capability.AnimalCooldownCapability;
import epicsquid.mysticalworld.capability.AnimalCooldownCapabilityStorage;
import epicsquid.mysticalworld.capability.PlayerShoulderCapability;
import epicsquid.mysticalworld.capability.PlayerShoulderCapabilityStorage;
import epicsquid.mysticalworld.events.CapabilityHandler;
import epicsquid.mysticalworld.events.DamageHandler;
import epicsquid.mysticalworld.events.EntityHandler;
import epicsquid.mysticalworld.events.LeafHandler;
import epicsquid.mysticalworld.events.LootHandler;
import epicsquid.mysticalworld.events.ShoulderHandler;
import epicsquid.mysticalworld.init.ModBlocks;
import epicsquid.mysticalworld.init.ModCompost;
import epicsquid.mysticalworld.init.ModEntities;
import epicsquid.mysticalworld.init.ModFeatures;
import epicsquid.mysticalworld.network.Networking;
import epicsquid.mysticalworld.potions.PotionRecipes;
import epicsquid.mysticalworld.setup.ClientSetup;
import epicsquid.mysticalworld.setup.ModifyLoot;
import epicsquid.mysticalworld.world.OreGen;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;

public class CommonSetup {
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ModCompost.init();
            ModEntities.registerEntities();
            Networking.INSTANCE.registerMessages();
            CapabilityManager.INSTANCE.register(AnimalCooldownCapability.class, (Capability.IStorage)new AnimalCooldownCapabilityStorage(), AnimalCooldownCapability::new);
            CapabilityManager.INSTANCE.register(IPlayerShoulderCapability.class, (Capability.IStorage)new PlayerShoulderCapabilityStorage(), PlayerShoulderCapability::new);
            OreGen.registerOreGeneration();
            PotionRecipes.registerRecipes();
            Set validBlocks = (Set)ObfuscationReflectionHelper.getPrivateValue(TileEntityType.class, (Object)TileEntityType.field_200985_p, (String)"field_223046_I");
            if (validBlocks != null) {
                HashSet newValidBlocks = Sets.newHashSet((Iterable)validBlocks);
                newValidBlocks.addAll(Arrays.asList((AbstractSkullBlock)ModBlocks.DROWNED_HEAD.get(), (AbstractSkullBlock)ModBlocks.DROWNED_WALL_HEAD.get(), (AbstractSkullBlock)ModBlocks.HUSK_HEAD.get(), (AbstractSkullBlock)ModBlocks.HUSK_WALL_HEAD.get(), (AbstractSkullBlock)ModBlocks.STRAY_HEAD.get(), (AbstractSkullBlock)ModBlocks.STRAY_WALL_HEAD.get(), (AbstractSkullBlock)ModBlocks.PILLAGER_HEAD.get(), (AbstractSkullBlock)ModBlocks.PILLAGER_WALL_HEAD.get(), (AbstractSkullBlock)ModBlocks.ZOMBIE_PIGMAN_HEAD.get(), (AbstractSkullBlock)ModBlocks.ZOMBIE_PIGMAN_WALL_HEAD.get(), (AbstractSkullBlock)ModBlocks.VILLAGER_HEAD.get(), (AbstractSkullBlock)ModBlocks.VILLAGER_WALL_HEAD.get(), (AbstractSkullBlock)ModBlocks.ZOMBIE_VILLAGER_HEAD.get(), (AbstractSkullBlock)ModBlocks.ZOMBIE_VILLAGER_WALL_HEAD.get()));
                ObfuscationReflectionHelper.setPrivateValue(TileEntityType.class, (Object)TileEntityType.field_200985_p, (Object)newValidBlocks, (String)"field_223046_I");
            } else {
                MysticalWorld.LOG.error("Unable to replace valid blocks for SkullTileEntity.");
            }
        });
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        ModFeatures.loadComplete();
    }

    public void serverStarting(FMLServerStartedEvent event) {
    }

    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        ModifyLoot.modify();
    }

    public void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(LeafHandler::onBlockDrops);
        MinecraftForge.EVENT_BUS.addListener(DamageHandler::onAttackDamage);
        MinecraftForge.EVENT_BUS.addListener(EntityHandler::onEntityInteract);
        MinecraftForge.EVENT_BUS.addListener(ShoulderHandler::onDeath);
        MinecraftForge.EVENT_BUS.addListener(ShoulderHandler::onRightClickBlock);
        MinecraftForge.EVENT_BUS.addListener(LootHandler::onLootLoad);
        MinecraftForge.EVENT_BUS.addListener(LootHandler::onLooting);
        MinecraftForge.EVENT_BUS.addListener(CapabilityHandler::attachCapability);
        MinecraftForge.EVENT_BUS.addListener(CapabilityHandler::onSquidMilked);
        MinecraftForge.EVENT_BUS.addListener(CapabilityHandler::onPlayerJoin);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ClientSetup::registerListeners);
    }
}

