/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.world.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.WorldSavedData;

public class StructureSaveData
extends WorldSavedData {
    public static final String ID = "MysticalWorld-StructureSaveData";
    private Map<ResourceLocation, List<BlockPos>> generatorMap = new HashMap<ResourceLocation, List<BlockPos>>();

    public StructureSaveData(String name) {
        super(name);
    }

    public StructureSaveData() {
        super(ID);
    }

    public List<BlockPos> getGeneratorMap(ResourceLocation location) {
        return this.generatorMap.computeIfAbsent(location, k -> new ArrayList());
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT keyList = nbt.func_150295_c("keyList", 8);
        for (int i = 0; i < keyList.size(); ++i) {
            String key = keyList.func_150307_f(i);
            ResourceLocation rl = new ResourceLocation(key);
            ListNBT positions = nbt.func_150295_c(key, 4);
            List<BlockPos> posList = this.generatorMap.get(rl);
            if (posList == null) {
                posList = new ArrayList<BlockPos>();
                this.generatorMap.put(rl, posList);
            } else {
                posList.clear();
            }
            for (int j = 0; j < positions.size(); ++j) {
                long l = ((LongNBT)positions.get(j)).func_150291_c();
                posList.add(BlockPos.func_218283_e((long)l));
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT stringKeyList = new ListNBT();
        for (Map.Entry<ResourceLocation, List<BlockPos>> entry : this.generatorMap.entrySet()) {
            ResourceLocation rl = entry.getKey();
            String name = rl.toString();
            stringKeyList.add((Object)new StringNBT(name));
            ListNBT positions = new ListNBT();
            for (BlockPos p : entry.getValue()) {
                positions.add((Object)new LongNBT(p.func_218275_a()));
            }
            compound.func_218657_a(name, (INBT)positions);
        }
        compound.func_218657_a("keyList", (INBT)stringKeyList);
        return compound;
    }
}

