/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import epicsquid.mysticalworld.config.IConfig;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class MobConfig
implements IConfig {
    protected String name;
    protected int chance;
    protected int min;
    protected int max;
    protected List<String> biomes;
    protected ForgeConfigSpec.IntValue configChance;
    protected ForgeConfigSpec.IntValue configMin;
    protected ForgeConfigSpec.IntValue configMax;
    protected ForgeConfigSpec.ConfigValue<String> configBiomes;

    public MobConfig(String name, int chance, int min, int max, List<String> biomes) {
        this.name = name;
        this.chance = chance;
        this.min = min;
        this.max = max;
        this.biomes = biomes;
    }

    public int getChance() {
        return (Integer)this.configChance.get();
    }

    public int getMin() {
        return (Integer)this.configMin.get();
    }

    public int getMax() {
        return (Integer)this.configMax.get();
    }

    public List<String> getBiomes() {
        String values = (String)this.configBiomes.get();
        return Arrays.asList(values.split(","));
    }

    public boolean shouldRegister() {
        return this.getChance() > 0;
    }

    protected void preApply(ForgeConfigSpec.Builder builder) {
    }

    protected void doApply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " spawn config.").push(this.name + "_spawn");
        this.configChance = builder.comment("Chance to spawn (set to 0 to disable).").defineInRange("spawnChance", this.chance, 0, 256);
        this.configMin = builder.comment("Min to spawn in a group.").defineInRange("min", this.min, 0, 256);
        this.configMax = builder.comment("Max to spawn in a group.").defineInRange("max", this.max, 0, 256);
        StringBuilder sb = new StringBuilder();
        this.biomes.forEach(biome -> {
            sb.append((String)biome);
            sb.append(",");
        });
        this.configBiomes = builder.comment("List of biome types to spawn.").define("biomes", (Object)sb.toString());
    }

    protected void postApply(ForgeConfigSpec.Builder builder) {
        builder.pop();
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        this.preApply(builder);
        this.doApply(builder);
        this.postApply(builder);
    }
}

