/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import epicsquid.mysticalworld.config.IConfig;
import epicsquid.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ForgeConfigSpec;
import noobanidus.libs.repack_mysticalworld.noobutil.block.BaseBlocks;

public class OreConfig
implements IConfig {
    private String name;
    private int chance;
    private int minY;
    private int maxY;
    private int size;
    private List<? extends Integer> dimensions;
    private Supplier<RegistryEntry<BaseBlocks.OreBlock>> ore;
    private ForgeConfigSpec.IntValue configChance;
    private ForgeConfigSpec.IntValue configMinY;
    private ForgeConfigSpec.IntValue configMaxY;
    private ForgeConfigSpec.IntValue configSize;
    private ForgeConfigSpec.ConfigValue<List<? extends Integer>> configDimensions;

    public OreConfig(String name, int chance, int minY, int maxY, int size, List<Integer> dimensions, Supplier<RegistryEntry<BaseBlocks.OreBlock>> ore) {
        this.name = name;
        this.chance = chance;
        this.minY = minY;
        this.maxY = maxY;
        this.size = size;
        this.ore = ore;
        this.dimensions = dimensions;
    }

    public String getName() {
        return this.name;
    }

    public int getChance() {
        return (Integer)this.configChance.get();
    }

    public int getMinY() {
        return (Integer)this.configMinY.get();
    }

    public int getMaxY() {
        return (Integer)this.configMaxY.get();
    }

    public int getSize() {
        return (Integer)this.configSize.get();
    }

    public Block getOre() {
        return (Block)this.ore.get().get();
    }

    public List<? extends Integer> getDimensions() {
        return (List)this.configDimensions.get();
    }

    public DimensionType[] getDimensionsAsArray() {
        ArrayList dimensions = new ArrayList();
        ((List)this.configDimensions.get()).forEach(o -> dimensions.add(DimensionType.func_186069_a((int)o)));
        return dimensions.toArray(new DimensionType[0]);
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " ore generation.").push(this.name + "_oregen");
        this.configChance = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("oreChances", this.chance, 0, 256);
        this.configSize = builder.comment("Max size of the vein.").defineInRange("veinSize", this.size, 1, 256);
        this.configMinY = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("minY", this.minY, 0, 256);
        this.configMaxY = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("maxY", this.maxY, 0, 256);
        this.configDimensions = builder.comment("The dimensions that this ore should spawn in as a list (default [0], overworld)").defineList("dimensions", this.dimensions, o -> true);
        builder.pop();
    }
}

