/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.events.mappings;

import epicsquid.mysticalworld.MysticalWorld;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class Remaps {
    public static ResourceLocation IGNORE = new ResourceLocation("mysticalworld", "ignore_remap");
    public static Map<ResourceLocation, ResourceLocation> remappedItems = new HashMap<ResourceLocation, ResourceLocation>();
    public static Map<ResourceLocation, ResourceLocation> remappedBlocks = new HashMap<ResourceLocation, ResourceLocation>();
    public static Map<ResourceLocation, ResourceLocation> remappedEntities = new HashMap<ResourceLocation, ResourceLocation>();

    private static void ignore(String oldName, RemapType type) {
        Remaps.remap(oldName, "ignore_remap", type);
    }

    private static void remap(String oldName, String newName, RemapType type) {
        Map<ResourceLocation, ResourceLocation> remapper = type.getMap().get();
        String mapType = type.getName();
        ResourceLocation oldRL = new ResourceLocation("mysticalworld", oldName);
        ResourceLocation newRL = new ResourceLocation("mysticalworld", newName);
        if (remapper.containsKey(oldRL)) {
            MysticalWorld.LOG.error("Invalid " + mapType + " remap: " + oldRL.toString() + " already exists and remaps to " + remapper.get(oldRL).toString() + ", cannot also remap to " + newRL.toString(), (Throwable)new IllegalStateException("Duplicate " + mapType + " remap"));
        }
        remapper.put(oldRL, newRL);
    }

    public static void remapItem(String o, String n) {
        Remaps.remap(o, n, RemapType.ITEM);
    }

    public static void remapBlock(String o, String n) {
        Remaps.remap(o, n, RemapType.BLOCK);
    }

    public static void remapEntity(String o, String n) {
        Remaps.remap(o, n, RemapType.ENTITY);
    }

    public static void remapItemEvent(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedItems.get(mapping.key);
            if (remap != null && remap.equals((Object)IGNORE)) {
                mapping.ignore();
                continue;
            }
            if (remap == null) continue;
            mapping.remap(Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(remap)));
        }
    }

    public static void remapBlockEvent(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedBlocks.get(mapping.key);
            if (remap != null && remap.equals((Object)IGNORE)) {
                mapping.ignore();
                continue;
            }
            if (remap == null) continue;
            mapping.remap(Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(remap)));
        }
    }

    public static void remapEntityEvent(RegistryEvent.MissingMappings<EntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedEntities.get(mapping.key);
            if (remap != null && remap.equals((Object)IGNORE)) {
                mapping.ignore();
                continue;
            }
            if (remap == null) continue;
            mapping.remap(Objects.requireNonNull(ForgeRegistries.ENTITIES.getValue(remap)));
        }
    }

    static {
        Remaps.ignore("drowned_head", RemapType.ITEM);
        Remaps.ignore("stray_head", RemapType.ITEM);
        Remaps.ignore("husk_head", RemapType.ITEM);
        Remaps.ignore("villager_head", RemapType.ITEM);
        Remaps.ignore("pillager_head", RemapType.ITEM);
        Remaps.ignore("zombie_pigman_head", RemapType.ITEM);
        Remaps.ignore("zombie_villager_head", RemapType.ITEM);
        Remaps.ignore("drowned_head", RemapType.BLOCK);
        Remaps.ignore("stray_head", RemapType.BLOCK);
        Remaps.ignore("husk_head", RemapType.BLOCK);
        Remaps.ignore("villager_head", RemapType.BLOCK);
        Remaps.ignore("pillager_head", RemapType.BLOCK);
        Remaps.ignore("zombie_pigman_head", RemapType.BLOCK);
        Remaps.ignore("zombie_villager_head", RemapType.BLOCK);
        Remaps.ignore("drowned_wall_head", RemapType.BLOCK);
        Remaps.ignore("stray_wall_head", RemapType.BLOCK);
        Remaps.ignore("husk_wall_head", RemapType.BLOCK);
        Remaps.ignore("villager_wall_head", RemapType.BLOCK);
        Remaps.ignore("pillager_wall_head", RemapType.BLOCK);
        Remaps.ignore("zombie_pigman_wall_head", RemapType.BLOCK);
        Remaps.ignore("zombie_villager_wall_head", RemapType.BLOCK);
    }

    public static enum RemapType {
        ITEM("item", () -> remappedItems),
        BLOCK("block", () -> remappedBlocks),
        ENTITY("entity", () -> remappedEntities);

        private String name;
        private Supplier<Map<ResourceLocation, ResourceLocation>> map;

        public String getName() {
            return this.name;
        }

        public Supplier<Map<ResourceLocation, ResourceLocation>> getMap() {
            return this.map;
        }

        private RemapType(String name, Supplier<Map<ResourceLocation, ResourceLocation>> map) {
            this.name = name;
            this.map = map;
        }
    }
}

