/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.repack.registrate.builders;

import epicsquid.mysticalworld.repack.registrate.AbstractRegistrate;
import epicsquid.mysticalworld.repack.registrate.builders.AbstractBuilder;
import epicsquid.mysticalworld.repack.registrate.builders.BuilderCallback;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonnullType;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ContainerBuilder<T extends Container, S extends Screen, P>
extends AbstractBuilder<ContainerType<?>, ContainerType<T>, P, ContainerBuilder<T, S, P>> {
    private final ContainerFactory<T> factory;
    private final NonNullSupplier<ScreenFactory<T, S>> screenFactory;

    public ContainerBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ContainerFactory<T> factory, NonNullSupplier<ScreenFactory<T, S>> screenFactory) {
        super(owner, parent, name, callback, ContainerType.class);
        this.factory = factory;
        this.screenFactory = screenFactory;
    }

    @Override
    @NonnullType
    protected ContainerType<T> createEntry() {
        ContainerFactory factory = this.factory;
        NonNullSupplier supplier = this.asSupplier();
        ContainerType ret = new ContainerType((windowId, inv) -> factory.create((ContainerType)supplier.get(), windowId, inv));
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ScreenFactory screenFactory = this.screenFactory.get();
            ScreenManager.func_216911_a((ContainerType)ret, (type, inv, displayName) -> screenFactory.create(type, inv, displayName));
        });
        return ret;
    }

    public static interface ScreenFactory<C extends Container, T extends Screen> {
        public T create(C var1, PlayerInventory var2, ITextComponent var3);
    }

    public static interface ContainerFactory<T extends Container> {
        public T create(ContainerType<T> var1, int var2, PlayerInventory var3);
    }
}

