/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.naturalprogression;

import com.mojang.serialization.Codec;
import com.oitsjustjose.naturalprogression.client.ClientProxy;
import com.oitsjustjose.naturalprogression.common.CommonProxy;
import com.oitsjustjose.naturalprogression.common.blocks.NaturalProgressionBlocks;
import com.oitsjustjose.naturalprogression.common.config.CommonConfig;
import com.oitsjustjose.naturalprogression.common.event.BoneEvent;
import com.oitsjustjose.naturalprogression.common.event.GroundBreak;
import com.oitsjustjose.naturalprogression.common.event.StoneBreak;
import com.oitsjustjose.naturalprogression.common.event.ToolNeutering;
import com.oitsjustjose.naturalprogression.common.event.WoodBreak;
import com.oitsjustjose.naturalprogression.common.items.NaturalProgressionItems;
import com.oitsjustjose.naturalprogression.common.recipes.DamageItemRecipe;
import com.oitsjustjose.naturalprogression.common.recipes.RecipeRemover;
import com.oitsjustjose.naturalprogression.common.world.feature.PebbleFeature;
import com.oitsjustjose.naturalprogression.common.world.feature.TwigFeature;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="natural-progression")
public class NaturalProgression {
    private static NaturalProgression instance;
    public Logger LOGGER = LogManager.getLogger();
    public static CommonProxy proxy;
    public static final IRecipeSerializer<DamageItemRecipe> DAMAGE_ITEM_RECIPE;

    public NaturalProgression() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new RecipeRemover());
        MinecraftForge.EVENT_BUS.register((Object)new WoodBreak());
        MinecraftForge.EVENT_BUS.register((Object)new StoneBreak());
        MinecraftForge.EVENT_BUS.register((Object)new GroundBreak());
        MinecraftForge.EVENT_BUS.register((Object)new ToolNeutering());
        MinecraftForge.EVENT_BUS.register((Object)new BoneEvent());
        this.configSetup();
    }

    public static NaturalProgression getInstance() {
        return instance;
    }

    private void configSetup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CommonConfig.COMMON_CONFIG);
        CommonConfig.loadConfig(CommonConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("natural-progression-common.toml"));
    }

    @SubscribeEvent
    public void onBiomesLoaded(BiomeLoadingEvent evt) {
        BiomeGenerationSettingsBuilder settings = evt.getGeneration();
        PebbleFeature p = new PebbleFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        TwigFeature t = new TwigFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        settings.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, p.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
        settings.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, t.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
    }

    public void setupClient(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)NaturalProgressionBlocks.twigs, (RenderType)RenderType.func_228643_e_());
    }

    static {
        proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        DAMAGE_ITEM_RECIPE = new DamageItemRecipe.Serializer();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            NaturalProgressionBlocks.registerBlocks(blockRegistryEvent);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            NaturalProgressionBlocks.registerBlockItems(itemRegistryEvent);
            NaturalProgressionItems.registerItems(itemRegistryEvent);
        }

        @SubscribeEvent
        public static void onRegisterSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)((IRecipeSerializer)DAMAGE_ITEM_RECIPE.setRegistryName(new ResourceLocation("natural-progression", "damage_tools"))));
        }
    }
}

