/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.naturalprogression.common.blocks;

import com.oitsjustjose.naturalprogression.NaturalProgression;
import com.oitsjustjose.naturalprogression.common.blocks.PebbleBlock;
import com.oitsjustjose.naturalprogression.common.blocks.TwigBlock;
import com.oitsjustjose.naturalprogression.common.items.PebbleItem;
import com.oitsjustjose.naturalprogression.common.utils.NaturalProgressionGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NaturalProgressionBlocks {
    public static HashMap<Block, Block> blocksToPebbles = new HashMap();
    private static ArrayList<Block> modBlocks = new ArrayList();
    public static Block twigs;

    private static void registerPebble(String modid, String path) {
        ResourceLocation rl = new ResourceLocation(modid, path);
        ResourceLocation pebbleRl = new ResourceLocation("natural-progression", (modid.toLowerCase() == "minecraft" ? "" : modid + "_") + path + "_pebble");
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(rl);
        if (b != null && b != Blocks.field_150350_a) {
            Block pebble = (Block)new PebbleBlock().setRegistryName(pebbleRl);
            modBlocks.add(pebble);
            blocksToPebbles.put(b, pebble);
        } else {
            NaturalProgression.getInstance().LOGGER.warn("{}:{} could not be found. No pebble will be created", (Object)modid, (Object)path);
        }
    }

    private static void registerCobble(String modid, String path) {
        AbstractBlock.Properties cobbleProps = AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 6.0f);
        ResourceLocation rl = new ResourceLocation(modid, path);
        ResourceLocation cobbleRl = new ResourceLocation("natural-progression", (modid.toLowerCase() == "minecraft" ? "" : modid + "_") + "cobbled_" + path);
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(rl);
        if (b != null && b != Blocks.field_150350_a) {
            Block cobble = (Block)new Block(cobbleProps).setRegistryName(cobbleRl);
            modBlocks.add(cobble);
        } else {
            NaturalProgression.getInstance().LOGGER.warn("{}:{} could not be found. No cobble will be created", (Object)modid, (Object)path);
        }
    }

    public static void registerBlocks(RegistryEvent.Register<Block> blockRegistryEvent) {
        NaturalProgressionBlocks.registerPebble("minecraft", "stone");
        NaturalProgressionBlocks.registerPebble("minecraft", "andesite");
        NaturalProgressionBlocks.registerPebble("minecraft", "diorite");
        NaturalProgressionBlocks.registerPebble("minecraft", "granite");
        NaturalProgressionBlocks.registerPebble("minecraft", "sandstone");
        NaturalProgressionBlocks.registerPebble("minecraft", "red_sandstone");
        NaturalProgressionBlocks.registerPebble("quark", "marble");
        NaturalProgressionBlocks.registerPebble("quark", "limestone");
        NaturalProgressionBlocks.registerPebble("quark", "jasper");
        NaturalProgressionBlocks.registerPebble("quark", "slate");
        NaturalProgressionBlocks.registerPebble("quark", "basalt");
        NaturalProgressionBlocks.registerPebble("create", "limestone");
        NaturalProgressionBlocks.registerPebble("create", "weathered_limestone");
        NaturalProgressionBlocks.registerPebble("create", "dolomite");
        NaturalProgressionBlocks.registerPebble("create", "gabbro");
        NaturalProgressionBlocks.registerPebble("create", "scoria");
        NaturalProgressionBlocks.registerPebble("create", "dark_scoria");
        NaturalProgressionBlocks.registerCobble("minecraft", "andesite");
        NaturalProgressionBlocks.registerCobble("minecraft", "diorite");
        NaturalProgressionBlocks.registerCobble("minecraft", "granite");
        NaturalProgressionBlocks.registerCobble("minecraft", "sandstone");
        NaturalProgressionBlocks.registerCobble("minecraft", "red_sandstone");
        twigs = (Block)new TwigBlock().setRegistryName(new ResourceLocation("natural-progression", "twigs"));
        blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)twigs);
        for (Block b : modBlocks) {
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)b);
        }
    }

    public static void registerBlockItems(RegistryEvent.Register<Item> itemRegistryEvent) {
        for (Block block : modBlocks) {
            Item iBlock;
            if (block instanceof PebbleBlock) {
                iBlock = (Item)new PebbleItem(block).setRegistryName(Objects.requireNonNull(block.getRegistryName()));
                itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)iBlock);
                continue;
            }
            iBlock = (Item)new BlockItem(block, new Item.Properties().func_200916_a((ItemGroup)NaturalProgressionGroup.getInstance())).setRegistryName(Objects.requireNonNull(block.getRegistryName()));
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)iBlock);
        }
    }
}

