/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.naturalprogression.common.items;

import com.oitsjustjose.naturalprogression.NaturalProgression;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;

public class DynamicItemTier
implements IItemTier {
    private int maxUses;
    private float efficiency;
    private float attackDamage;
    private int harvestLvl;
    private int enchantability;
    private Ingredient repairMat;

    public DynamicItemTier(int maxUses, float eff, float dmg, int harv, int ench, Ingredient repairMat) {
        this.maxUses = maxUses;
        this.efficiency = eff;
        this.attackDamage = dmg;
        this.harvestLvl = harv;
        this.enchantability = ench;
        this.repairMat = repairMat;
    }

    public DynamicItemTier(int maxUses, float eff, float dmg, int harv, int ench, ITag<Item> repairMatTag) {
        this.maxUses = maxUses;
        this.efficiency = eff;
        this.attackDamage = dmg;
        this.harvestLvl = harv;
        this.enchantability = ench;
        this.repairMat = Ingredient.func_199805_a(repairMatTag);
    }

    public DynamicItemTier() {
        this.maxUses = 0;
        this.efficiency = 0.0f;
        this.attackDamage = 0.0f;
        this.harvestLvl = 0;
        this.enchantability = 0;
        this.repairMat = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221598_z});
    }

    public DynamicItemTier setMaxUses(int maxUses) {
        this.maxUses = maxUses;
        return this;
    }

    public DynamicItemTier setEfficiency(float eff) {
        this.efficiency = eff;
        return this;
    }

    public DynamicItemTier setAttackDamage(float dmg) {
        this.attackDamage = dmg;
        return this;
    }

    public DynamicItemTier setHarvestLvl(int lvl) {
        this.harvestLvl = lvl;
        return this;
    }

    public DynamicItemTier setEnchantability(int ench) {
        this.enchantability = ench;
        return this;
    }

    public DynamicItemTier setRepairMat(Ingredient mat) {
        this.repairMat = mat;
        return this;
    }

    public DynamicItemTier setRepairMat(@Nullable ITag<Item> tag) {
        if (tag == null || tag.func_230236_b_().isEmpty()) {
            this.repairMat = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221598_z});
            NaturalProgression.getInstance().LOGGER.warn("Dynamic saw repair material {} could not be found. Defaulting to Bedrock", (Object)(tag == null ? "" : tag.toString()));
        } else {
            this.repairMat = Ingredient.func_199805_a(tag);
        }
        return this;
    }

    public DynamicItemTier setRepairMats(Item ... items) {
        this.repairMat = Ingredient.func_199804_a((IItemProvider[])items);
        return this;
    }

    public int func_200926_a() {
        return this.maxUses;
    }

    public float func_200928_b() {
        return this.efficiency;
    }

    public float func_200929_c() {
        return this.attackDamage;
    }

    public int func_200925_d() {
        return this.harvestLvl;
    }

    public int func_200927_e() {
        return this.enchantability;
    }

    @Nonnull
    public Ingredient func_200924_f() {
        return this.repairMat;
    }
}

