/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.naturalprogression.common.recipes;

import com.google.common.collect.ImmutableMap;
import com.oitsjustjose.naturalprogression.NaturalProgression;
import com.oitsjustjose.naturalprogression.common.config.CommonConfig;
import com.oitsjustjose.naturalprogression.common.recipes.DamageItemRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ToolItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeRemover {
    private static final Field RECIPES = ObfuscationReflectionHelper.findField(RecipeManager.class, (String)"field_199522_d");

    @SubscribeEvent
    public void onServerStart(FMLServerStartedEvent evt) {
        RecipeRemover.remove(evt.getServer().func_199529_aN());
    }

    @SubscribeEvent
    public void addReloadListener(final AddReloadListenerEvent evt) {
        evt.addListener((IFutureReloadListener)new ReloadListener<Void>(){

            protected void apply(Void objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
                RecipeRemover.remove(evt.getDataPackRegistries().func_240967_e_());
            }

            protected Void prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
                return null;
            }
        });
    }

    private static void remove(RecipeManager mgr) {
        ToolItem t;
        if (((Boolean)CommonConfig.REMOVE_WOODEN_TOOL_RECIPES.get()).booleanValue()) {
            for (Item i : ForgeRegistries.ITEMS.getValues()) {
                if (!(i instanceof ToolItem) || (t = (ToolItem)i).func_200891_e() != ItemTier.WOOD) continue;
                RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)t, 1));
            }
        }
        if (((Boolean)CommonConfig.REMOVE_STONE_TOOL_RECIPES.get()).booleanValue()) {
            for (Item i : ForgeRegistries.ITEMS.getValues()) {
                if (!(i instanceof ToolItem) || (t = (ToolItem)i).func_200891_e() != ItemTier.STONE) continue;
                RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)t, 1));
            }
        }
    }

    private static void removeRecipes(RecipeManager recipeManager, ItemStack stack) {
        int recipesRemoved = RecipeRemover.removeRecipes(recipeManager, (IRecipe recipe) -> {
            ItemStack recipeOutput = recipe.func_77571_b();
            return recipeOutput.equals(stack, false) && !(recipe.func_199559_b() instanceof DamageItemRecipe.Serializer);
        });
        NaturalProgression.getInstance().LOGGER.info("Removed {} recipe(s) for {}", (Object)recipesRemoved, (Object)stack.func_200301_q().getString());
    }

    private static void removeRecipes(RecipeManager recipeManager, ITag.INamedTag<Item> tag) {
        try {
            int recipesRemoved = RecipeRemover.removeRecipes(recipeManager, (IRecipe recipe) -> {
                ItemStack recipeOutput = recipe.func_77571_b();
                return !recipeOutput.func_190926_b() && recipeOutput.func_77973_b().func_206844_a((ITag)tag) && !(recipe.func_199559_b() instanceof DamageItemRecipe.Serializer);
            });
            NaturalProgression.getInstance().LOGGER.info("Removed {} recipe(s) for tag {}", (Object)recipesRemoved, (Object)tag.func_230234_a_());
        }
        catch (IllegalStateException ex) {
            return;
        }
    }

    private static int removeRecipes(RecipeManager recipeManager, Predicate<IRecipe> predicate) {
        Map existingRecipes;
        try {
            Map recipesMap;
            existingRecipes = recipesMap = (Map)RECIPES.get(recipeManager);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't get recipes map while removing recipes", e);
        }
        Object2IntOpenHashMap removedCounts = new Object2IntOpenHashMap();
        ImmutableMap.Builder newRecipes = ImmutableMap.builder();
        existingRecipes.forEach((arg_0, arg_1) -> RecipeRemover.lambda$removeRecipes$3(predicate, (Object2IntMap)removedCounts, newRecipes, arg_0, arg_1));
        int removedCount = removedCounts.values().stream().reduce(0, Integer::sum);
        try {
            RECIPES.set(recipeManager, newRecipes.build());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't replace recipes map while removing recipes", e);
        }
        return removedCount;
    }

    private static /* synthetic */ void lambda$removeRecipes$3(Predicate predicate, Object2IntMap removedCounts, ImmutableMap.Builder newRecipes, IRecipeType recipeType, Map existingRecipesForType) {
        ImmutableMap newRecipesForType = (ImmutableMap)existingRecipesForType.entrySet().stream().filter(entry -> !predicate.test((IRecipe)entry.getValue())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        removedCounts.put((Object)recipeType, existingRecipesForType.size() - newRecipesForType.size());
        newRecipes.put((Object)recipeType, (Object)newRecipesForType);
    }
}

