/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.naturalprogression.common.utils;

import com.oitsjustjose.naturalprogression.NaturalProgression;
import com.oitsjustjose.naturalprogression.common.blocks.NaturalProgressionBlocks;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.server.ServerWorld;

public class Utils {
    public static Block getPebbleForPos(IWorld world, BlockPos pos) {
        BlockPos search = new BlockPos(pos.func_177958_n(), world.func_217301_I(), pos.func_177952_p());
        for (int y = 0; y < search.func_177956_o(); ++y) {
            if (world.func_180495_p(search.func_177979_c(y)).func_185904_a() == Material.field_151579_a || !NaturalProgressionBlocks.blocksToPebbles.containsKey(world.func_180495_p(search.func_177979_c(y)).func_177230_c())) continue;
            return NaturalProgressionBlocks.blocksToPebbles.get(world.func_180495_p(search.func_177979_c(y)).func_177230_c());
        }
        return NaturalProgressionBlocks.blocksToPebbles.get(Blocks.field_150348_b);
    }

    public static boolean canReplace(BlockState stateAtPos, IWorld world, BlockPos searchPos) {
        return stateAtPos.func_185904_a().func_76224_d() || stateAtPos.func_185904_a() == Material.field_151579_a;
    }

    public static boolean isInWater(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150355_j || state.func_235901_b_((Property)BlockStateProperties.field_208198_y);
    }

    public static boolean inNonWaterFluid(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76224_d() && !Utils.isInWater(world, pos);
    }

    @Nullable
    public static BlockPos getPebblePos(IWorld world, ChunkPos chunkPos) {
        Random random = new Random();
        int blockPosX = (chunkPos.field_77276_a << 4) + random.nextInt(16);
        int blockPosZ = (chunkPos.field_77275_b << 4) + random.nextInt(16);
        BlockPos searchPos = new BlockPos(blockPosX, world.func_217301_I(), blockPosZ);
        for (int i = 0; i < searchPos.func_177956_o(); ++i) {
            BlockState stateAtPos = world.func_180495_p(searchPos.func_177979_c(i));
            BlockState stateBelow = world.func_180495_p(searchPos.func_177979_c(i + 1));
            if (!Utils.canReplace(stateAtPos, world, searchPos) || !stateBelow.func_200132_m() || !stateBelow.func_185904_a().func_76230_c()) continue;
            return searchPos.func_177979_c(i);
        }
        return null;
    }

    public static String dimensionToString(IWorld world) {
        if (world instanceof World) {
            return Objects.requireNonNull(((World)world).func_234923_W_().func_240901_a_().toString());
        }
        if (world instanceof ServerWorld) {
            return Objects.requireNonNull(((ServerWorld)world).func_234923_W_().func_240901_a_().toString());
        }
        if (world instanceof WorldGenRegion) {
            return Objects.requireNonNull(((WorldGenRegion)world).func_201672_e().func_234923_W_().func_240901_a_().toString());
        }
        NaturalProgression.getInstance().LOGGER.warn("Utils.dimensionToString called on IWorld object that couldn't be interpreted");
        return "ERR";
    }
}

