/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.naturalprogression.common.world.feature;

import com.mojang.serialization.Codec;
import com.oitsjustjose.naturalprogression.NaturalProgression;
import com.oitsjustjose.naturalprogression.common.blocks.PebbleBlock;
import com.oitsjustjose.naturalprogression.common.config.CommonConfig;
import com.oitsjustjose.naturalprogression.common.utils.Utils;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerWorld;

public class PebbleFeature
extends Feature<NoFeatureConfig> {
    public PebbleFeature(Codec<NoFeatureConfig> p_i231976_1_) {
        super(p_i231976_1_);
    }

    private void doPlace(IWorld world, BlockPos pos) {
        for (int i = 0; i < (Integer)CommonConfig.MAX_PEBBLES_PER_CHUNK.get(); ++i) {
            BlockState stateToPlace;
            BlockPos pebblePos = Utils.getPebblePos(world, new ChunkPos(pos));
            if (pebblePos == null || Utils.inNonWaterFluid(world, pebblePos)) continue;
            Block pebble = Utils.getPebbleForPos(world, pebblePos);
            if (world.func_180495_p(pebblePos).func_177230_c() instanceof PebbleBlock) continue;
            boolean isInWater = Utils.isInWater(world, pebblePos);
            BlockState blockState = stateToPlace = isInWater ? (BlockState)pebble.func_176223_P().func_206870_a((Property)PebbleBlock.WATERLOGGED, (Comparable)Boolean.TRUE) : pebble.func_176223_P();
            if (!world.func_180501_a(pebblePos, stateToPlace, 18) || !Utils.canReplace(world.func_180495_p(pebblePos.func_177984_a()), world, pebblePos.func_177984_a())) continue;
            world.func_175655_b(pos.func_177984_a(), false);
        }
    }

    @ParametersAreNonnullByDefault
    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        ServerWorld iworld = reader.func_201672_e();
        if (!(iworld instanceof ServerWorld)) {
            return false;
        }
        ServerWorld world = iworld;
        if (world.func_72863_F().func_201711_g() instanceof FlatChunkGenerator) {
            return false;
        }
        if (!((List)CommonConfig.DIMENSION_WHITELIST.get()).contains(Utils.dimensionToString((IWorld)world))) {
            return false;
        }
        try {
            return this.func_207803_a((IWorld)reader, rand, pos);
        }
        catch (Exception e) {
            NaturalProgression.getInstance().LOGGER.error(e.getMessage());
            return false;
        }
    }

    protected boolean func_207803_a(IWorld world, Random rand, BlockPos pos) {
        this.doPlace(world, pos);
        return true;
    }
}

