/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.naturalprogression.common.world.feature;

import com.mojang.serialization.Codec;
import com.oitsjustjose.naturalprogression.NaturalProgression;
import com.oitsjustjose.naturalprogression.common.blocks.NaturalProgressionBlocks;
import com.oitsjustjose.naturalprogression.common.blocks.TwigBlock;
import com.oitsjustjose.naturalprogression.common.config.CommonConfig;
import com.oitsjustjose.naturalprogression.common.utils.Utils;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerWorld;

public class TwigFeature
extends Feature<NoFeatureConfig> {
    public TwigFeature(Codec<NoFeatureConfig> p_i231976_1_) {
        super(p_i231976_1_);
    }

    private void doPlace(IWorld world, BlockPos pos) {
        for (int i = 0; i < (Integer)CommonConfig.MAX_TWIGS_PER_CHUNK.get(); ++i) {
            BlockState stateToPlace;
            BlockPos twigPos = Utils.getPebblePos(world, new ChunkPos(pos));
            if (twigPos == null || Utils.inNonWaterFluid(world, twigPos) || world.func_180495_p(twigPos).func_177230_c() instanceof TwigBlock) continue;
            boolean isInWater = Utils.isInWater(world, twigPos);
            BlockState blockState = stateToPlace = isInWater ? (BlockState)NaturalProgressionBlocks.twigs.func_176223_P().func_206870_a((Property)TwigBlock.WATERLOGGED, (Comparable)Boolean.TRUE) : NaturalProgressionBlocks.twigs.func_176223_P();
            if (!world.func_180501_a(twigPos, stateToPlace, 18) || !Utils.canReplace(world.func_180495_p(twigPos.func_177984_a()), world, twigPos.func_177984_a())) continue;
            world.func_175655_b(pos.func_177984_a(), false);
        }
    }

    @ParametersAreNonnullByDefault
    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        ServerWorld iworld = reader.func_201672_e();
        if (!(iworld instanceof ServerWorld)) {
            return false;
        }
        ServerWorld world = iworld;
        if (world.func_72863_F().func_201711_g() instanceof FlatChunkGenerator) {
            return false;
        }
        if (!((List)CommonConfig.DIMENSION_WHITELIST.get()).contains(Utils.dimensionToString((IWorld)world))) {
            return false;
        }
        try {
            return this.func_207803_a((IWorld)reader, rand, pos);
        }
        catch (Exception e) {
            NaturalProgression.getInstance().LOGGER.error(e.getMessage());
            return false;
        }
    }

    protected boolean func_207803_a(IWorld world, Random rand, BlockPos pos) {
        this.doPlace(world, pos);
        return true;
    }
}

