/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.api.aura.container;

import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import net.minecraft.nbt.CompoundNBT;

public class BasicAuraContainer
implements IAuraContainer {
    protected final IAuraType type;
    protected final int maxAura;
    protected int aura;

    public BasicAuraContainer(IAuraType type, int maxAura) {
        this.type = type;
        this.maxAura = maxAura;
    }

    @Override
    public int storeAura(int amountToStore, boolean simulate) {
        int actual = Math.min(amountToStore, this.maxAura - this.aura);
        if (!simulate) {
            this.aura += actual;
        }
        return actual;
    }

    @Override
    public int drainAura(int amountToDrain, boolean simulate) {
        int actual = Math.min(amountToDrain, this.aura);
        if (!simulate) {
            this.aura -= actual;
        }
        return actual;
    }

    @Override
    public int getStoredAura() {
        return this.aura;
    }

    @Override
    public int getMaxAura() {
        return this.maxAura;
    }

    @Override
    public int getAuraColor() {
        return 2001182;
    }

    @Override
    public boolean isAcceptableType(IAuraType type) {
        return this.type == null || type.isSimilar(this.type);
    }

    public void writeNBT(CompoundNBT compound) {
        compound.func_74768_a("aura", this.aura);
    }

    public void readNBT(CompoundNBT compound) {
        this.aura = compound.func_74762_e("aura");
    }
}

