/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityAuraBloom;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.ICustomRenderType;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class BlockAuraBloom
extends BushBlock
implements IModItem,
ICustomBlockState,
ICustomItemModel,
ICustomRenderType {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private final String baseName;
    private final Block[] allowedGround;

    public BlockAuraBloom(String baseName, Block ... allowedGround) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c));
        this.baseName = baseName;
        this.allowedGround = allowedGround;
        ModRegistry.add(this);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        return this.func_200014_a_(worldIn.func_180495_p(down), (IBlockReader)worldIn, down);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return Arrays.stream(this.allowedGround).anyMatch(arg_0 -> ((BlockState)state).func_203425_a(arg_0));
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (this == ModBlocks.AURA_CACTUS) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d vec3d = state.func_191059_e(worldIn, pos);
        return SHAPE.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cross(this.getBaseName(), generator.modLoc("block/" + this.getBaseName())));
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/generated")).texture("layer0", "block/" + this.getBaseName());
    }

    @Override
    public Supplier<RenderType> getRenderType() {
        return RenderType::func_228643_e_;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityAuraBloom();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }
}

