/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockAncientLeaves;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;

public class BlockGoldenLeaves
extends LeavesBlock
implements IModItem,
IColorProvidingBlock,
IColorProvidingItem,
ICustomBlockState {
    public static final int HIGHEST_STAGE = 3;
    public static final IntegerProperty STAGE = IntegerProperty.func_177719_a((String)"stage", (int)0, (int)3);

    public BlockGoldenLeaves() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151584_j, (MaterialColor)MaterialColor.field_151647_F).func_200943_b(0.2f).func_200944_c().func_226896_b_().func_200947_a(SoundType.field_185850_c));
        ModRegistry.add(this);
    }

    public static boolean convert(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof LeavesBlock && !(state.func_177230_c() instanceof BlockAncientLeaves) && !(state.func_177230_c() instanceof BlockGoldenLeaves)) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, (BlockState)((BlockState)ModBlocks.GOLDEN_LEAVES.func_176223_P().func_206870_a((Property)field_208494_a, (Comparable)(state.func_235901_b_((Property)field_208494_a) ? (Integer)state.func_177229_b((Property)field_208494_a) : Integer.valueOf(1)))).func_206870_a((Property)field_208495_b, (Comparable)(state.func_235901_b_((Property)field_208495_b) ? (Boolean)state.func_177229_b((Property)field_208495_b) : Boolean.valueOf(false))));
            }
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "golden_leaves";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.func_177229_b((Property)STAGE) == 3 && rand.nextFloat() >= 0.75f) {
            NaturesAuraAPI.instance().spawnMagicParticle((float)pos.func_177958_n() + rand.nextFloat(), (float)pos.func_177956_o() + rand.nextFloat(), (float)pos.func_177952_p() + rand.nextFloat(), 0.0, 0.0, 0.0, 0xF2FF00, 0.5f + rand.nextFloat(), 50, 0.0f, false, true);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{STAGE});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IBlockColor getBlockColor() {
        return (state, worldIn, pos, tintIndex) -> {
            int color = 0xF2FF00;
            if (state != null && worldIn != null && pos != null) {
                int foliage = BiomeColors.func_228361_b_((IBlockDisplayReader)worldIn, (BlockPos)pos);
                return Helper.blendColors(color, foliage, (float)((Integer)state.func_177229_b((Property)STAGE)).intValue() / 3.0f);
            }
            return color;
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IItemColor getItemColor() {
        return (stack, tintIndex) -> 0xF2FF00;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
        if (!worldIn.field_72995_K) {
            BlockPos offset;
            int stage = (Integer)state.func_177229_b((Property)STAGE);
            if (stage < 3) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)));
            }
            if (stage > 1 && worldIn.func_175667_e(offset = pos.func_177972_a(Direction.func_239631_a_((Random)random)))) {
                BlockGoldenLeaves.convert((World)worldIn, offset);
            }
        }
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }
}

