/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class TileEntityChorusGenerator
extends TileEntityImpl
implements ITickableTileEntity {
    private final Deque<BlockPos> currentlyBreaking = new ArrayDeque<BlockPos>();
    private int auraPerBlock;

    public TileEntityChorusGenerator() {
        super(ModTileEntities.CHORUS_GENERATOR);
    }

    public void func_73660_a() {
        BlockPos spot;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 5L != 0L) {
            return;
        }
        if (this.currentlyBreaking.isEmpty()) {
            return;
        }
        BlockPos pos = this.currentlyBreaking.removeLast();
        BlockState state = this.field_145850_b.func_180495_p(pos);
        if (state.func_177230_c() != Blocks.field_185765_cR && state.func_177230_c() != Blocks.field_185766_cS) {
            this.currentlyBreaking.clear();
            return;
        }
        PacketHandler.sendToAllAround(this.field_145850_b, this.field_174879_c, 32, new PacketParticles(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), PacketParticles.Type.CHORUS_GENERATOR, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        this.field_145850_b.func_217377_a(pos, false);
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187544_ad, SoundCategory.BLOCKS, 0.5f, 1.0f);
        for (int aura = this.auraPerBlock; aura > 0; aura -= IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, spot).storeAura(spot, aura)) {
            spot = IAuraChunk.getLowestSpot((IWorld)this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
        }
    }

    @Override
    public void onRedstonePowerChange(int newPower) {
        if (this.redstonePower <= 0 && newPower > 0 && this.currentlyBreaking.isEmpty()) {
            int range = 2;
            block0: for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockState state;
                        BlockPos offset = this.field_174879_c.func_177982_a(x, y, z);
                        BlockState below = this.field_145850_b.func_180495_p(offset.func_177977_b());
                        if (below.func_177230_c() != Blocks.field_150377_bs || (state = this.field_145850_b.func_180495_p(offset)).func_177230_c() != Blocks.field_185765_cR) continue;
                        ArrayList<BlockPos> plants = new ArrayList<BlockPos>();
                        this.collectChorusPlant(offset, plants);
                        if (plants.size() <= 1) continue;
                        this.currentlyBreaking.addAll(plants);
                        this.currentlyBreaking.addFirst(offset);
                        int aura = plants.size() * plants.size() * 300;
                        this.auraPerBlock = aura / plants.size();
                        break block0;
                    }
                }
            }
        }
        super.onRedstonePowerChange(newPower);
    }

    private void collectChorusPlant(BlockPos pos, List<BlockPos> blocks) {
        for (Direction dir : Direction.values()) {
            BlockState state;
            BlockPos offset;
            if (dir == Direction.DOWN || blocks.contains(offset = pos.func_177972_a(dir)) || (state = this.field_145850_b.func_180495_p(offset)).func_177230_c() != Blocks.field_185765_cR && state.func_177230_c() != Blocks.field_185766_cS) continue;
            blocks.add(offset);
            this.collectChorusPlant(offset, blocks);
        }
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == TileEntityImpl.SaveType.TILE) {
            ListNBT list = new ListNBT();
            for (BlockPos pos : this.currentlyBreaking) {
                list.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
            }
            compound.func_218657_a("breaking", (INBT)list);
            compound.func_74768_a("aura", this.auraPerBlock);
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == TileEntityImpl.SaveType.TILE) {
            this.currentlyBreaking.clear();
            ListNBT list = compound.func_150295_c("breaking", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.currentlyBreaking.add(NBTUtil.func_186861_c((CompoundNBT)list.func_150305_b(i)));
            }
            this.auraPerBlock = compound.func_74762_e("aura");
        }
    }
}

