/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class TileEntityFieldCreator
extends TileEntityImpl
implements ITickableTileEntity {
    public BlockPos connectionOffset;
    public boolean isMain;
    public boolean isCharged;
    private int chargeTimer;

    public TileEntityFieldCreator() {
        super(ModTileEntities.FIELD_CREATOR);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 10L != 0L) {
            return;
        }
        BlockPos connectedPos = this.getConnectedPos();
        if (connectedPos == null || !this.field_145850_b.func_175667_e(connectedPos)) {
            return;
        }
        TileEntity other = this.field_145850_b.func_175625_s(connectedPos);
        if (!(this.isCloseEnough(connectedPos) && other instanceof TileEntityFieldCreator && this.field_174879_c.equals((Object)((TileEntityFieldCreator)other).getConnectedPos()))) {
            this.connectionOffset = null;
            this.chargeTimer = 0;
            this.isCharged = false;
            this.isMain = false;
            this.sendToClients();
            return;
        }
        if (!this.isMain) {
            return;
        }
        TileEntityFieldCreator creator = (TileEntityFieldCreator)other;
        if (this.redstonePower <= 0 && creator.redstonePower <= 0) {
            this.chargeTimer = 0;
            if (this.isCharged) {
                this.isCharged = false;
                this.sendToClients();
                creator.isCharged = false;
                creator.sendToClients();
            }
            return;
        }
        BlockPos spot = IAuraChunk.getHighestSpot((IWorld)this.field_145850_b, this.field_174879_c, 32, this.field_174879_c);
        IAuraChunk chunk = IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, spot);
        if (!this.isCharged) {
            this.chargeTimer += 10;
            if (this.chargeTimer >= 150) {
                this.chargeTimer = 0;
                this.isCharged = true;
                this.sendToClients();
                creator.isCharged = true;
                creator.sendToClients();
            }
            chunk.drainAura(spot, 300);
            this.sendParticles();
        } else {
            if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                chunk.drainAura(spot, 20);
            }
            ItemStack tool = this.getToolUsed(creator);
            Vector3d dist = new Vector3d((double)(this.field_174879_c.func_177958_n() - connectedPos.func_177958_n()), (double)(this.field_174879_c.func_177956_o() - connectedPos.func_177956_o()), (double)(this.field_174879_c.func_177952_p() - connectedPos.func_177952_p()));
            double length = dist.func_72433_c();
            Vector3d normal = new Vector3d(dist.field_72450_a / length, dist.field_72448_b / length, dist.field_72449_c / length);
            for (float i = (float)MathHelper.func_76128_c((double)length); i > 0.0f; i -= 0.5f) {
                FakePlayer fake;
                BlockState state;
                Block block;
                Vector3d scaled = normal.func_186678_a((double)i);
                BlockPos pos = connectedPos.func_177982_a(MathHelper.func_76128_c((double)(scaled.field_72450_a + 0.5)), MathHelper.func_76128_c((double)(scaled.field_72448_b + 0.5)), MathHelper.func_76128_c((double)(scaled.field_72449_c + 0.5)));
                if (pos.equals((Object)this.field_174879_c) || pos.equals((Object)connectedPos) || (block = (state = this.field_145850_b.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockReader)this.field_145850_b, pos) || !(state.func_185887_b((IBlockReader)this.field_145850_b, pos) >= 0.0f) || MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.field_145850_b, pos, state, (PlayerEntity)(fake = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_145850_b)))))) continue;
                List drops = state.func_215693_a(new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_216281_a, (Object)fake).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216287_g, (Object)state).func_216015_a(LootParameters.field_216289_i, (Object)(tool.func_190926_b() ? new ItemStack((IItemProvider)Items.field_151046_w) : tool)).func_216021_b(LootParameters.field_216288_h, (Object)this.field_145850_b.func_175625_s(pos)));
                this.field_145850_b.func_175655_b(pos, false);
                for (ItemStack stack : drops) {
                    Block.func_180635_a((World)this.field_145850_b, (BlockPos)pos, (ItemStack)stack);
                }
                chunk.drainAura(spot, !tool.func_190926_b() ? 300 : 100);
                this.sendParticles();
            }
        }
    }

    private ItemStack getToolUsed(TileEntityFieldCreator other) {
        ItemStack myTool = this.getMyTool();
        ItemStack otherTool = other.getMyTool();
        if (!myTool.func_190926_b()) {
            if (!otherTool.func_190926_b()) {
                return this.field_145850_b.field_73012_v.nextBoolean() ? myTool : otherTool;
            }
            return myTool;
        }
        return otherTool;
    }

    private ItemStack getMyTool() {
        List<ItemFrameEntity> frames = Helper.getAttachedItemFrames(this.field_145850_b, this.field_174879_c);
        for (ItemFrameEntity frame : frames) {
            ItemStack stack = frame.func_82335_i();
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private void sendParticles() {
        for (int j = 0; j < 2; ++j) {
            BlockPos p = j == 0 ? this.field_174879_c : this.getConnectedPos();
            PacketHandler.sendToAllAround(this.field_145850_b, p, 32, new PacketParticleStream((float)p.func_177958_n() + (float)this.field_145850_b.field_73012_v.nextGaussian() * 3.0f, (float)(p.func_177956_o() + 1) + this.field_145850_b.field_73012_v.nextFloat() * 3.0f, (float)p.func_177952_p() + (float)this.field_145850_b.field_73012_v.nextGaussian() * 3.0f, (float)p.func_177958_n() + 0.5f, (float)p.func_177956_o() + 0.5f, (float)p.func_177952_p() + 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.07f + 0.07f, IAuraType.forWorld((IWorld)this.field_145850_b).getColor(), this.field_145850_b.field_73012_v.nextFloat() + 0.5f));
        }
    }

    public boolean isCloseEnough(BlockPos pos) {
        int range = (Integer)ModConfig.instance.fieldCreatorRange.get() + 1;
        return this.field_174879_c.func_177951_i((Vector3i)pos) <= (double)(range * range);
    }

    public BlockPos getConnectedPos() {
        if (this.connectionOffset == null) {
            return null;
        }
        return this.field_174879_c.func_177971_a((Vector3i)this.connectionOffset);
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            if (this.connectionOffset != null) {
                compound.func_74772_a("connection", this.connectionOffset.func_218275_a());
            }
            compound.func_74757_a("main", this.isMain);
            compound.func_74757_a("charged", this.isCharged);
            if (type == TileEntityImpl.SaveType.TILE) {
                compound.func_74768_a("timer", this.chargeTimer);
            }
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.connectionOffset = compound.func_74764_b("connection") ? BlockPos.func_218283_e((long)compound.func_74763_f("connection")) : null;
            this.isMain = compound.func_74767_n("main");
            this.isCharged = compound.func_74767_n("charged");
            if (type == TileEntityImpl.SaveType.TILE) {
                this.chargeTimer = compound.func_74762_e("timer");
            }
        }
    }
}

