/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class TileEntitySlimeSplitGenerator
extends TileEntityImpl
implements ITickableTileEntity {
    private int generationTimer;
    private int amountToRelease;
    private int color;

    public TileEntitySlimeSplitGenerator() {
        super(ModTileEntities.SLIME_SPLIT_GENERATOR);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 10L != 0L) {
            return;
        }
        if (this.generationTimer > 0) {
            int amount = this.amountToRelease * 10;
            if (this.canGenerateRightNow(35, amount)) {
                while (amount > 0) {
                    BlockPos pos = IAuraChunk.getLowestSpot((IWorld)this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
                    amount -= IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, pos).storeAura(pos, amount);
                }
                PacketHandler.sendToAllAround(this.field_145850_b, this.field_174879_c, 32, new PacketParticles(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), PacketParticles.Type.SLIME_SPLIT_GEN_CREATE, this.color));
            }
            this.generationTimer -= 10;
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }

    public boolean isBusy() {
        return this.generationTimer > 0;
    }

    public void startGenerating(SlimeEntity slime) {
        int size = slime.func_70809_q();
        this.generationTimer = size * 30;
        this.amountToRelease = size * this.getGenerationAmount(slime) / this.generationTimer;
        this.color = this.getSlimeColor(slime);
        PacketHandler.sendToAllAround(this.field_145850_b, this.field_174879_c, 32, new PacketParticles((float)slime.func_226277_ct_(), (float)slime.func_226278_cu_(), (float)slime.func_226281_cx_(), PacketParticles.Type.SLIME_SPLIT_GEN_START, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.color));
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == TileEntityImpl.SaveType.TILE) {
            compound.func_74768_a("timer", this.generationTimer);
            compound.func_74768_a("amount", this.amountToRelease);
            compound.func_74768_a("color", this.color);
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == TileEntityImpl.SaveType.TILE) {
            this.generationTimer = compound.func_74762_e("timer");
            this.amountToRelease = compound.func_74762_e("amount");
            this.color = compound.func_74762_e("color");
        }
    }

    private int getSlimeColor(SlimeEntity slime) {
        if (slime instanceof MagmaCubeEntity) {
            return 9708822;
        }
        return 5089359;
    }

    private int getGenerationAmount(SlimeEntity slime) {
        if (slime instanceof MagmaCubeEntity) {
            return 45000;
        }
        return 25000;
    }
}

