/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class NetherDecayEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "nether_decay");
    private int amount;
    private int dist;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        if (spot >= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea((IWorld)world, pos, 50);
        if (aura >= 0) {
            return false;
        }
        this.amount = Math.min(300, MathHelper.func_76123_f((float)((float)Math.abs(aura) / 50000.0f / (float)IAuraChunk.getSpotAmountInArea((IWorld)world, pos, 50))));
        if (this.amount <= 1) {
            return false;
        }
        this.dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 50000), (int)5, (int)75);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(PlayerEntity player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((IItemProvider)Items.field_221693_cI);
    }

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        for (int i = this.amount / 2 + world.field_73012_v.nextInt(this.amount / 2); i >= 0; --i) {
            BlockPos offset = new BlockPos((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * (double)this.dist, (double)pos.func_177956_o() + world.field_73012_v.nextGaussian() * (double)this.dist, (double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * (double)this.dist);
            if (offset.func_177951_i((Vector3i)pos) > (double)(this.dist * this.dist) || !world.func_175667_e(offset)) continue;
            Block degraded = null;
            BlockState state = world.func_180495_p(offset);
            if (state.func_177230_c() == Blocks.field_150426_aN) {
                degraded = Blocks.field_150424_aL;
            } else if (state.func_177230_c().func_203417_a((ITag)BlockTags.field_232873_an_) || state.func_177230_c() == Blocks.field_150424_aL) {
                degraded = Blocks.field_235336_cN_;
            } else if (state.func_177230_c() == Blocks.field_235336_cN_) {
                degraded = Blocks.field_150425_aM;
            }
            if (degraded != null) {
                world.func_217379_c(2001, offset, Block.func_196246_j((BlockState)state));
                world.func_175656_a(offset, degraded.func_176223_P());
            }
            if (!AbstractFireBlock.func_241465_a_((World)world, (BlockPos)offset, (Direction)Direction.NORTH)) continue;
            BlockState fire = AbstractFireBlock.func_235326_a_((IBlockReader)world, (BlockPos)offset);
            world.func_175656_a(offset, fire);
            world.func_217379_c(1009, offset, 0);
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.netherDecayEffect.get() != false && type.isSimilar(NaturesAuraAPI.TYPE_NETHER);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

