/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.multiblock.Matcher;
import de.ellpeck.naturesaura.compat.ICompat;
import de.ellpeck.naturesaura.data.ItemTagProvider;
import de.ellpeck.naturesaura.events.ClientEvents;
import de.ellpeck.naturesaura.renderers.SupporterFancyHandler;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.gui.GuiUtils;
import vazkii.patchouli.api.BookDrawScreenEvent;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.PatchouliAPI;

public class PatchouliCompat
implements ICompat {
    private static final ResourceLocation BOOK = new ResourceLocation("naturesaura", "book");

    public static void addPatchouliMultiblock(ResourceLocation name, String[][] pattern, Object ... rawMatchers) {
        for (int i = 1; i < rawMatchers.length; i += 2) {
            if (!(rawMatchers[i] instanceof Matcher)) continue;
            Matcher matcher = (Matcher)rawMatchers[i];
            Matcher.ICheck check = matcher.getCheck();
            rawMatchers[i] = check == null ? PatchouliAPI.instance.anyMatcher() : PatchouliAPI.instance.predicateMatcher(matcher.getDefaultState(), state -> check.matches(null, null, null, null, (BlockState)state, '\u0000'));
        }
        DeferredWorkQueue.runLater(() -> PatchouliAPI.instance.registerMultiblock(name, PatchouliAPI.instance.makeMultiblock(pattern, rawMatchers)));
    }

    public static <T extends IRecipe<?>> T getRecipe(String type, String name) {
        RecipeManager manager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        ResourceLocation res = new ResourceLocation(name);
        ResourceLocation pre = new ResourceLocation(res.func_110624_b(), type + "/" + res.func_110623_a());
        return (T)((IRecipe)manager.func_215367_a(pre).orElse(null));
    }

    public static IVariable ingredientVariable(Ingredient ingredient) {
        return IVariable.wrapList((Iterable)Arrays.stream(ingredient.func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
    }

    @Override
    public void setup() {
        DeferredWorkQueue.runLater(() -> {
            PatchouliAPI.instance.setConfigFlag("naturesaura:rf_converter", ((Boolean)ModConfig.instance.rfConverter.get()).booleanValue());
            PatchouliAPI.instance.setConfigFlag("naturesaura:chunk_loader", ((Boolean)ModConfig.instance.chunkLoader.get()).booleanValue());
        });
    }

    @Override
    public void setupClient() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void addItemTags(ItemTagProvider provider) {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onBookDraw(BookDrawScreenEvent event) {
        int y;
        int x;
        if (event.book == null || !event.book.equals((Object)BOOK)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        if (now.getMonth() == Month.MAY && now.getDayOfMonth() == 21) {
            x = event.gui.field_230708_k_ / 2 + 136 - 16;
            y = event.gui.field_230709_l_ / 2 - 90 - 26;
            RenderHelper.func_74518_a();
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.gui.getMinecraft().func_110434_K().func_110577_a(ClientEvents.BOOK_GUI);
            AbstractGui.func_238463_a_((MatrixStack)event.matrixStack, (int)x, (int)y, (float)469.0f, (float)0.0f, (int)43, (int)42, (int)512, (int)256);
            if (event.mouseX >= x && event.mouseY >= y && event.mouseX < x + 43 && event.mouseY < y + 42) {
                GuiUtils.drawHoveringText((MatrixStack)event.matrixStack, Collections.singletonList(new StringTextComponent("It's the author Ellpeck's birthday!").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD))), (int)event.mouseX, (int)event.mouseY, (int)event.gui.field_230708_k_, (int)event.gui.field_230709_l_, (int)0, (FontRenderer)event.gui.getMinecraft().field_71466_p);
            }
        } else if (now.getMonth() == Month.JUNE) {
            x = event.gui.field_230708_k_ / 2 + 136;
            y = event.gui.field_230709_l_ / 2 - 90 + 16;
            RenderHelper.func_74518_a();
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.gui.getMinecraft().func_110434_K().func_110577_a(ClientEvents.BOOK_GUI);
            AbstractGui.func_238463_a_((MatrixStack)event.matrixStack, (int)x, (int)y, (float)424.0f, (float)0.0f, (int)45, (int)26, (int)512, (int)256);
            if (event.mouseX >= x && event.mouseY >= y && event.mouseX < x + 45 && event.mouseY < y + 26) {
                GuiUtils.drawHoveringText((MatrixStack)event.matrixStack, Collections.singletonList(new StringTextComponent("\u00c2\u00a76Happy \u00c2\u00a74P\u00c2\u00a76r\u00c2\u00a7ei\u00c2\u00a72d\u00c2\u00a79e\u00c2\u00a75!")), (int)event.mouseX, (int)event.mouseY, (int)event.gui.field_230708_k_, (int)event.gui.field_230709_l_, (int)0, (FontRenderer)event.gui.getMinecraft().field_71466_p);
            }
        }
        String name = event.gui.getMinecraft().field_71439_g.func_200200_C_().getString();
        SupporterFancyHandler.FancyInfo info = SupporterFancyHandler.FANCY_INFOS.get(name);
        if (info != null) {
            int x2 = event.gui.field_230708_k_ / 2 - 136 + 20;
            int y2 = event.gui.field_230709_l_ / 2 + 90;
            RenderHelper.func_74518_a();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.gui.getMinecraft().func_110434_K().func_110577_a(ClientEvents.BOOK_GUI);
            AbstractGui.func_238463_a_((MatrixStack)event.matrixStack, (int)x2, (int)y2, (float)496.0f, (float)44.0f, (int)16, (int)18, (int)512, (int)256);
            if (info.tier == 1) {
                AbstractGui.func_238463_a_((MatrixStack)event.matrixStack, (int)x2, (int)y2, (float)480.0f, (float)44.0f, (int)16, (int)18, (int)512, (int)256);
            } else {
                float r = (float)(info.color >> 16 & 0xFF) / 255.0f;
                float g = (float)(info.color >> 8 & 0xFF) / 255.0f;
                float b = (float)(info.color & 0xFF) / 255.0f;
                RenderSystem.color3f((float)r, (float)g, (float)b);
                AbstractGui.func_238463_a_((MatrixStack)event.matrixStack, (int)x2, (int)y2, (float)464.0f, (float)44.0f, (int)16, (int)18, (int)512, (int)256);
            }
            if (event.mouseX >= x2 && event.mouseY >= y2 && event.mouseX < x2 + 16 && event.mouseY < y2 + 18) {
                GuiUtils.drawHoveringText((MatrixStack)event.matrixStack, Collections.singletonList(new StringTextComponent("Thanks for your support, " + name + "!").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW))), (int)event.mouseX, (int)event.mouseY, (int)event.gui.field_230708_k_, (int)event.gui.field_230709_l_, (int)0, (FontRenderer)event.gui.getMinecraft().field_71466_p);
            }
        }
    }
}

