/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.projectile.EyeOfEnderEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityStructureFinder
extends EyeOfEnderEntity {
    public static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityStructureFinder.class, (IDataSerializer)DataSerializers.field_187192_b);
    private double targetX;
    private double targetY;
    private double targetZ;
    private int despawnTimer;
    private boolean shatterOrDrop;

    public EntityStructureFinder(EntityType<? extends EyeOfEnderEntity> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("color", ((Integer)this.field_70180_af.func_187225_a(COLOR)).intValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74762_e("color"));
    }

    public void func_180465_a(BlockPos pos) {
        double d3;
        double d0 = pos.func_177958_n();
        int i = pos.func_177956_o();
        double d1 = pos.func_177952_p();
        double d2 = d0 - this.func_226277_ct_();
        float f = MathHelper.func_76133_a((double)(d2 * d2 + (d3 = d1 - this.func_226281_cx_()) * d3));
        if (f > 12.0f) {
            this.targetX = this.func_226277_ct_() + d2 / (double)f * 12.0;
            this.targetZ = this.func_226281_cx_() + d3 / (double)f * 12.0;
            this.targetY = this.func_226278_cu_() + 8.0;
        } else {
            this.targetX = d0;
            this.targetY = i;
            this.targetZ = d1;
        }
        this.despawnTimer = 0;
        this.shatterOrDrop = this.field_70146_Z.nextInt(4) > 0;
    }

    public void func_70071_h_() {
        this.func_70030_z();
        Vector3d vec3d = this.func_213322_ci();
        double d0 = this.func_226277_ct_() + vec3d.field_72450_a;
        double d1 = this.func_226278_cu_() + vec3d.field_72448_b;
        double d2 = this.func_226281_cx_() + vec3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)EntityStructureFinder.func_213296_b((Vector3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (!this.field_70170_p.field_72995_K) {
            double d3 = this.targetX - d0;
            double d4 = this.targetZ - d2;
            float f1 = (float)Math.sqrt(d3 * d3 + d4 * d4);
            float f2 = (float)MathHelper.func_181159_b((double)d4, (double)d3);
            double d5 = MathHelper.func_219803_d((double)0.0025, (double)f, (double)f1);
            double d6 = vec3d.field_72448_b;
            if (f1 < 1.0f) {
                d5 *= 0.8;
                d6 *= 0.8;
            }
            int j = this.func_226278_cu_() < this.targetY ? 1 : -1;
            vec3d = new Vector3d(Math.cos(f2) * d5, d6 + ((double)j - d6) * (double)0.015f, Math.sin(f2) * d5);
            this.func_213317_d(vec3d);
        }
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d0 - vec3d.field_72450_a * 0.25, d1 - vec3d.field_72448_b * 0.25, d2 - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            }
        } else if (this.field_70170_p.field_72995_K) {
            NaturesAuraAPI.instance().spawnMagicParticle(d0 - vec3d.field_72450_a * 0.25 + this.field_70146_Z.nextDouble() * 0.6 - 0.3, d1 - vec3d.field_72448_b * 0.25 - 0.5, d2 - vec3d.field_72449_c * 0.25 + this.field_70146_Z.nextDouble() * 0.6 - 0.3, vec3d.field_72450_a * 0.25, vec3d.field_72448_b * 0.25, vec3d.field_72449_c * 0.25, (Integer)this.field_70180_af.func_187225_a(COLOR), 1.0f, 50, 0.0f, false, true);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70107_b(d0, d1, d2);
            ++this.despawnTimer;
            if (this.despawnTimer > 80 && !this.field_70170_p.field_72995_K) {
                this.func_184185_a(SoundEvents.field_193777_bb, 1.0f, 1.0f);
                this.func_70106_y();
                if (this.shatterOrDrop) {
                    this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_184543_l()));
                } else {
                    PacketHandler.sendToAllAround(this.field_70170_p, this.func_233580_cy_(), 32, new PacketParticles((float)this.func_226277_ct_(), (float)this.func_226278_cu_(), (float)this.func_226281_cx_(), PacketParticles.Type.STRUCTURE_FINDER, this.func_145782_y()));
                }
            }
        } else {
            this.func_226288_n_(d0, d1, d2);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

