/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.ellpeck.naturesaura.entities.EntityEffectInhibitor;
import de.ellpeck.naturesaura.items.ItemEffectPowder;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderEffectInhibitor
extends EntityRenderer<EntityEffectInhibitor> {
    private final Map<ResourceLocation, ItemStack> items = new HashMap<ResourceLocation, ItemStack>();

    public RenderEffectInhibitor(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getEntityTexture(EntityEffectInhibitor entity) {
        return AtlasTexture.field_110575_b;
    }

    public void render(EntityEffectInhibitor entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        float time = (float)(entity.renderTicks + entity.func_145782_y()) + partialTicks;
        float bob = (float)Math.sin(time / 10.0f) * 0.05f;
        matrixStackIn.func_227861_a_(0.0, (double)(0.15f + bob), 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(time * 3.0f % 360.0f));
        ResourceLocation effect = entity.getInhibitedEffect();
        ItemStack stack = this.items.computeIfAbsent(effect, res -> ItemEffectPowder.setEffect(new ItemStack((IItemProvider)ModItems.EFFECT_POWDER), effect));
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, packedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
        matrixStackIn.func_227865_b_();
    }
}

