/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModArmorMaterial;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemArmor
extends ArmorItem
implements IModItem {
    private static final AttributeModifier SKY_MOVEMENT_MODIFIER = new AttributeModifier(UUID.fromString("c1f96acc-e117-4dc1-a351-e196a4de6071"), "naturesaura:sky_movement_speed", (double)0.15f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final Map<IArmorMaterial, Item[]> SETS = new HashMap<IArmorMaterial, Item[]>();
    private final String baseName;

    public ItemArmor(String baseName, IArmorMaterial materialIn, EquipmentSlotType equipmentSlotIn) {
        super(materialIn, equipmentSlotIn, new Item.Properties().func_200916_a(NaturesAura.CREATIVE_TAB));
        this.baseName = baseName;
        ModRegistry.add(this);
    }

    public static boolean isFullSetEquipped(LivingEntity entity, IArmorMaterial material) {
        Item[] set = SETS.computeIfAbsent(material, m -> (Item[])ForgeRegistries.ITEMS.getValues().stream().filter(i -> i instanceof ItemArmor && ((ItemArmor)i).func_200880_d() == material).sorted(Comparator.comparingInt(i -> ((ItemArmor)i).func_185083_B_().ordinal())).toArray(Item[]::new));
        for (int i = 0; i < 4; ++i) {
            EquipmentSlotType slot = EquipmentSlotType.values()[i + 2];
            ItemStack stack = entity.func_184582_a(slot);
            if (stack.func_77973_b() == set[i] || slot == EquipmentSlotType.CHEST && stack.func_77973_b() == Items.field_185160_cR) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return Helper.makeRechargeProvider(stack, false);
    }

    @Mod.EventBusSubscriber
    private static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onAttack(LivingAttackEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (!entity.field_70170_p.field_72995_K) {
                if (!ItemArmor.isFullSetEquipped(entity, ModArmorMaterial.INFUSED)) {
                    return;
                }
                Entity source = event.getSource().func_76346_g();
                if (source instanceof LivingEntity) {
                    ((LivingEntity)source).func_195064_c(new EffectInstance(Effects.field_82731_v, 40));
                }
            }
        }

        @SubscribeEvent
        public static void update(TickEvent.PlayerTickEvent event) {
            PlayerEntity player = event.player;
            ModifiableAttributeInstance speed = player.func_110148_a(Attributes.field_233821_d_);
            String key = "naturesaura:sky_equipped";
            CompoundNBT nbt = player.getPersistentData();
            boolean equipped = ItemArmor.isFullSetEquipped((LivingEntity)player, ModArmorMaterial.SKY);
            if (equipped && !nbt.func_74767_n(key)) {
                nbt.func_74757_a(key, true);
                player.field_70138_W = 1.1f;
                if (!speed.func_180374_a(SKY_MOVEMENT_MODIFIER)) {
                    speed.func_233767_b_(SKY_MOVEMENT_MODIFIER);
                }
            } else if (!equipped && nbt.func_74767_n(key)) {
                nbt.func_74757_a(key, false);
                player.field_70138_W = 0.6f;
                speed.func_111124_b(SKY_MOVEMENT_MODIFIER);
            }
        }
    }
}

