/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.WeatherType;
import de.ellpeck.naturesaura.api.misc.WeightedOre;
import de.ellpeck.naturesaura.recipes.AltarRecipe;
import de.ellpeck.naturesaura.recipes.AnimalSpawnerRecipe;
import de.ellpeck.naturesaura.recipes.OfferingRecipe;
import de.ellpeck.naturesaura.recipes.TreeRitualRecipe;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModRecipes {
    public static final IRecipeType<AltarRecipe> ALTAR_TYPE = new RecipeType<AltarRecipe>();
    public static final IRecipeSerializer<AltarRecipe> ALTAR_SERIAIZER = new AltarRecipe.Serializer();
    public static final IRecipeType<AnimalSpawnerRecipe> ANIMAL_SPAWNER_TYPE = new RecipeType<AnimalSpawnerRecipe>();
    public static final IRecipeSerializer<AnimalSpawnerRecipe> ANIMAL_SPAWNER_SERIALIZER = new AnimalSpawnerRecipe.Serializer();
    public static final IRecipeType<OfferingRecipe> OFFERING_TYPE = new RecipeType<OfferingRecipe>();
    public static final IRecipeSerializer<OfferingRecipe> OFFERING_SERIALIZER = new OfferingRecipe.Serializer();
    public static final IRecipeType<TreeRitualRecipe> TREE_RITUAL_TYPE = new RecipeType<TreeRitualRecipe>();
    public static final IRecipeSerializer<TreeRitualRecipe> TREE_RITUAL_SERIALIZER = new TreeRitualRecipe.Serializer();

    public static void register(IForgeRegistry<IRecipeSerializer<?>> registry) {
        ModRecipes.register(registry, "altar", ALTAR_TYPE, ALTAR_SERIAIZER);
        ModRecipes.register(registry, "animal_spawner", ANIMAL_SPAWNER_TYPE, ANIMAL_SPAWNER_SERIALIZER);
        ModRecipes.register(registry, "offering", OFFERING_TYPE, OFFERING_SERIALIZER);
        ModRecipes.register(registry, "tree_ritual", TREE_RITUAL_TYPE, TREE_RITUAL_SERIALIZER);
    }

    public static void init() {
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.field_150347_e.func_176223_P(), (Object)Blocks.field_150341_Y.func_176223_P());
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.field_196696_di.func_176223_P(), (Object)Blocks.field_196698_dj.func_176223_P());
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.field_150463_bK.func_176223_P(), (Object)Blocks.field_196723_eg.func_176223_P());
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.field_222413_lB.func_176223_P(), (Object)Blocks.field_222462_lz.func_176223_P());
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/coal", 5000);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/coal", 5000);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/iron", 3000);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/iron", 3000);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/gold", 500);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/gold", 500);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/diamond", 50);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/diamond", 50);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/lapis", 250);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/lapis", 250);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/redstone", 200);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/redstone", 200);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/emerald", 30);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/emerald", 30);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/quartz", 8000);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/netherite_scrap", 30);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/copper", 2000);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/copper", 2000);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/tin", 1800);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/tin", 1800);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/lead", 1500);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/lead", 1500);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/silver", 1000);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/silver", 1000);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/nickel", 100);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/nickel", 100);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/platinum", 20);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/platinum", 20);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/aluminum", 1200);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/aluminium", 1200);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/osmium", 1500);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/zinc", 1000);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/yellorite", 1200);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/uranium", 400);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/apatite", 700);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/ruby", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/peridot", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/topaz", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/tanzanite", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/malachite", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/sapphire", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/amber", 150);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/resonating", 50);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/sulfur", 600);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/saltpeter", 250);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/firestone", 30);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/salt", 2900);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/draconium", 5);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/cobalt", 50);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/ardite", 50);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200751_aq, 10000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200746_al, 7000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200744_aj, 35000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200752_ar, 50000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200753_as, 200000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200790_d, 30000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200747_am, 40000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200739_ae, 300000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200770_J, 100000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_203098_aL, 3000000);
        NaturesAuraAPI.WEATHER_CHANGER_CONVERSIONS.put(new ItemStack((IItemProvider)Blocks.field_196800_gd), WeatherType.SUN);
        NaturesAuraAPI.WEATHER_CHANGER_CONVERSIONS.put(new ItemStack((IItemProvider)Items.field_221883_fZ), WeatherType.RAIN);
        NaturesAuraAPI.WEATHER_CHANGER_CONVERSIONS.put(new ItemStack((IItemProvider)Items.field_151059_bz), WeatherType.THUNDERSTORM);
    }

    private static void ore(List<WeightedOre> list, String name, int weight) {
        ResourceLocation res = new ResourceLocation("forge", name);
        list.add(new WeightedOre(res, weight));
    }

    private static void register(IForgeRegistry<IRecipeSerializer<?>> registry, String name, IRecipeType<?> type, IRecipeSerializer<?> serializer) {
        ResourceLocation res = new ResourceLocation("naturesaura", name);
        Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)res, type);
        registry.register((IForgeRegistryEntry)serializer.setRegistryName(res));
    }

    public static JsonObject serializeStack(ItemStack stack) {
        CompoundNBT nbt = stack.func_77955_b(new CompoundNBT());
        byte c = nbt.func_74771_c("Count");
        if (c != 1) {
            nbt.func_74774_a("count", c);
        }
        nbt.func_82580_o("Count");
        ModRecipes.renameTag(nbt, "id", "item");
        ModRecipes.renameTag(nbt, "tag", "nbt");
        Dynamic dyn = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    private static void renameTag(CompoundNBT nbt, String oldName, String newName) {
        INBT tag = nbt.func_74781_a(oldName);
        if (tag != null) {
            nbt.func_82580_o(oldName);
            nbt.func_218657_a(newName, tag);
        }
    }

    private static class RecipeType<T extends IRecipe<?>>
    implements IRecipeType<T> {
        private RecipeType() {
        }

        public String toString() {
            return Registry.field_218367_H.func_177774_c((Object)this).toString();
        }
    }
}

