/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.entities;

import blueduck.outerend.client.Color;
import blueduck.outerend.registry.BlockRegistry;
import blueduck.outerend.registry.ItemRegistry;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;

public class DragonflyEntity
extends MobEntity {
    private final FlyingPathNavigator pathNavigator;
    public Color color = new Color(0, 0, 0);
    private BlockPos target = null;

    public DragonflyEntity(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
        this.pathNavigator = new FlyingPathNavigator((MobEntity)this, this.field_70170_p);
    }

    public void setColor(int amt) {
        this.color = new Color(amt);
    }

    public int getColor() {
        return this.color.getRGB();
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public static AttributeModifierMap createModifiers() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233822_e_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233823_f_, 0.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233818_a_, 10.0).func_233813_a_();
    }

    public boolean shouldRepathfind() {
        return this.field_70173_aa % 1000 <= 10;
    }

    public Path getPath() {
        BlockPos pos = this.target;
        if (pos == null) {
            for (int i = 0; i <= 32; ++i) {
                int x1 = (int)this.func_226277_ct_() + this.field_70146_Z.nextInt(64) - 32;
                int z1 = (int)this.func_226281_cx_() + this.field_70146_Z.nextInt(64) - 32;
                int y = this.field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, x1, z1);
                boolean shouldFind = this.field_70146_Z.nextBoolean();
                if (y == 0) continue;
                if (pos != null) {
                    shouldFind = shouldFind && (this.field_70170_p.func_226691_t_(new BlockPos(x1, y, z1)).getRegistryName().toString().equals("outer_end:azure_forest") || !this.field_70170_p.func_226691_t_(pos).getRegistryName().toString().equals("outer_end:azure_forest"));
                    boolean bl = shouldFind = shouldFind || this.field_70170_p.func_226691_t_(new BlockPos(x1, y, z1)).getRegistryName().toString().equals("outer_end:azure_forest") && !this.field_70170_p.func_226691_t_(pos).getRegistryName().toString().equals("outer_end:azure_forest");
                }
                if (shouldFind && pos == null) {
                    pos = new BlockPos(x1, y, z1);
                }
                int searchDist = 8;
                for (int xOff = -searchDist; xOff <= searchDist; ++xOff) {
                    int x = x1 + xOff;
                    for (int zOff = -searchDist; zOff <= searchDist; ++zOff) {
                        int z = z1 + zOff;
                        int y1 = this.field_70170_p.func_201676_a(Heightmap.Type.MOTION_BLOCKING, x1, z1) + 1;
                        if (!this.field_70170_p.func_180495_p(new BlockPos(x, y1, z).func_177977_b()).func_177230_c().equals(BlockRegistry.AZURE_STAMEN.get()) || pos != null && y1 <= pos.func_177956_o()) continue;
                        pos = new BlockPos(x, y1, z);
                    }
                }
            }
            if (pos == null) {
                int x = (int)this.func_226277_ct_() + this.field_70146_Z.nextInt(64) - 32;
                int z = (int)this.func_226281_cx_() + this.field_70146_Z.nextInt(64) - 32;
                int y = this.field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z);
                pos = new BlockPos(x, Math.max(8, y), z);
            }
        }
        while (!this.field_70170_p.func_180495_p(pos).func_196958_f()) {
            pos = pos.func_177984_a();
        }
        Path path = this.pathNavigator.func_179680_a(pos, 1);
        this.target = pos;
        return path;
    }

    public void func_70071_h_() {
        boolean isAboveBlock;
        if (this.func_226278_cu_() < 1.0) {
            this.func_70665_d(DamageSource.field_76380_i, 5.0f);
        }
        if (this.func_130014_f_().field_72995_K || this.func_175446_cd()) {
            super.func_70071_h_();
            if (FMLEnvironment.dist.isClient()) {
                Color thisColor = new Color(this.getColor());
                try {
                    Color biomeColor = new Color(DragonflyEntity.getColor((Biome)ForgeRegistries.BIOMES.getValue(this.field_70170_p.func_242406_i(this.func_233580_cy_()).orElse(Biomes.field_76772_c).func_240901_a_())));
                    this.setColor(new Color((int)MathHelper.func_219799_g((float)0.1f, (float)thisColor.getRed(), (float)biomeColor.getRed()), (int)MathHelper.func_219799_g((float)0.1f, (float)thisColor.getGreen(), (float)biomeColor.getGreen()), (int)MathHelper.func_219799_g((float)0.1f, (float)thisColor.getBlue(), (float)biomeColor.getBlue())).getRGB());
                }
                catch (Throwable biomeColor) {
                    // empty catch block
                }
            }
            return;
        }
        this.field_70143_R = 0.0f;
        boolean bl = isAboveBlock = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_233580_cy_()).func_177956_o() >= 4;
        if ((this.target == null || this.pathNavigator.func_75505_d() == null || this.pathNavigator.func_75505_d().func_75879_b()) && (this.shouldRepathfind() && this.field_70122_E || this.func_189748_bU() != null || !isAboveBlock)) {
            this.pathNavigator.func_75499_g();
            this.pathNavigator.func_226336_g_();
            this.pathNavigator.func_75484_a(this.getPath(), 1.0);
        }
        if (!this.pathNavigator.func_226337_n_()) {
            this.target = null;
        }
        this.func_230245_c_(this.pathNavigator.func_75500_f());
        if (this.pathNavigator.func_75505_d() != null && this.pathNavigator.func_75505_d().func_75873_e() < this.pathNavigator.func_75505_d().func_75874_d() && this.target != null) {
            Vector3d targ = this.pathNavigator.func_75505_d().func_75881_a((Entity)this, this.pathNavigator.func_75505_d().func_75873_e());
            Vector3d vector3d2 = new Vector3d(targ.func_82615_a(), targ.func_82617_b(), targ.func_82616_c()).func_178788_d(this.func_213303_ch());
            Vector3d vector3d3 = new Vector3d((double)this.target.func_177958_n(), (double)this.target.func_177956_o(), (double)this.target.func_177952_p()).func_178788_d(this.func_213303_ch());
            vector3d3 = vector3d3.func_216372_d(1.0, 0.0, 1.0);
            this.pathNavigator.func_75501_e();
            Vector3d vector3d = new Vector3d(0.0, 0.0, 0.0);
            if (vector3d2.func_216372_d(1.0, 0.0, 1.0).func_72436_e(vector3d) <= 1.0) {
                this.field_70122_E = true;
                Vector3d vector3d4 = new Vector3d(this.func_213322_ci().field_72450_a, Math.max(-0.1, this.func_213322_ci().func_82617_b() - (double)0.1f), this.func_213322_ci().field_72449_c);
                boolean reachedTarget = this.func_233580_cy_().func_177967_a(Direction.DOWN, this.func_233580_cy_().func_177956_o()).equals((Object)this.pathNavigator.func_208485_j().func_177967_a(Direction.DOWN, this.pathNavigator.func_208485_j().func_177956_o()));
                if (this.func_226278_cu_() >= targ.func_82617_b() - 1.0) {
                    if (!reachedTarget) {
                        this.pathNavigator.func_75505_d().func_75875_a();
                    }
                    if (reachedTarget || this.pathNavigator.func_75505_d().func_75873_e() >= this.pathNavigator.func_75505_d().func_75874_d()) {
                        BlockPos blockPos = new BlockPos(this.target.func_177958_n(), 0, this.target.func_177952_p());
                        if (this.func_233580_cy_().func_177967_a(Direction.DOWN, this.func_233580_cy_().func_177956_o()).func_177951_i((Vector3i)blockPos) >= 1.0) {
                            this.pathNavigator.func_75484_a(this.getPath(), 1.0);
                        } else {
                            if (!this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_196958_f()) {
                                this.pathNavigator.func_75499_g();
                            }
                            this.target = null;
                        }
                    }
                    this.func_213317_d(vector3d4);
                }
            }
            if (this.target != null) {
                this.field_70122_E = false;
                boolean isAbove = this.func_213303_ch().field_72448_b >= (double)this.target.func_177956_o() + vector3d3.func_72436_e(new Vector3d(0.0, 0.0, 0.0)) / 128.0 && 0.0 >= vector3d2.func_82617_b() + 1.0;
                this.func_213293_j(MathHelper.func_219803_d((double)0.1f, (double)this.func_213322_ci().field_72450_a, (double)(vector3d2.func_72432_b().field_72450_a * (double)1.1f)), !isAbove ? Math.max(-0.1, this.func_213322_ci().field_72448_b + (double)0.1f) : MathHelper.func_219803_d((double)0.2f, (double)Math.max(-0.1, this.func_213322_ci().func_82617_b()), (double)-0.1f), MathHelper.func_219803_d((double)0.1f, (double)this.func_213322_ci().field_72449_c, (double)(vector3d2.func_72432_b().field_72449_c * (double)1.1f)));
            }
        }
        if (this.func_226278_cu_() <= 3.0) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, MathHelper.func_219803_d((double)0.1f, (double)this.func_213322_ci().field_72448_b, (double)-0.05f), this.func_213322_ci().field_72449_c);
        }
        if (this.func_226278_cu_() <= 2.9) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, MathHelper.func_219803_d((double)0.1f, (double)this.func_213322_ci().field_72448_b, (double)-0.01), this.func_213322_ci().field_72449_c);
        }
        if (this.func_226278_cu_() <= 2.8) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b + 0.5, this.func_213322_ci().field_72449_c);
        }
        if (this.func_110167_bD()) {
            Vector3d pos = this.func_110166_bE().func_213303_ch();
            if (this.func_195048_a(pos) >= 20.0) {
                this.func_213317_d(pos.func_178788_d(this.func_213303_ch()).func_186678_a((double)0.1f).func_178787_e(this.func_213322_ci()));
            }
            if (this.func_195048_a(pos) >= 256.0) {
                this.func_110160_i(true, true);
            }
        }
        super.func_70071_h_();
    }

    public static int getColor(Biome biome) {
        if (biome == null || biome.getRegistryName() == null) {
            return 0;
        }
        if (biome.getRegistryName().toString().equals("minecraft:crimson_forest")) {
            return new Color(255, 15, 15).getRGB();
        }
        if (biome.getRegistryName().toString().equals("minecraft:warped_forest")) {
            return new Color(19, 112, 118).getRGB();
        }
        if (biome.getRegistryName().toString().equals("minecraft:nether_wastes")) {
            return new Color(100, 16, 16).getRGB();
        }
        if (biome.getRegistryName().toString().equals("minecraft:soul_sand_valley")) {
            return new Color(41, 35, 34).getRGB();
        }
        if (biome.getRegistryName().toString().equals("minecraft:flower_forest")) {
            return new Color(252, 233, 78).getRGB();
        }
        if (biome.getRegistryName().toString().startsWith("minecraft:desert")) {
            return new Color(244, 216, 120).getRGB();
        }
        if (biome.func_201856_r().equals((Object)Biome.Category.THEEND) && biome.getRegistryName().func_110624_b().equals("minecraft")) {
            return new Color(255, 255, 255).getRGB();
        }
        if (biome.func_201856_r().equals((Object)Biome.Category.OCEAN) && biome.getRegistryName().func_110624_b().equals("minecraft")) {
            return new Color(89, 115, 165).getRGB();
        }
        if (biome.getRegistryName().toString().equals("minecraft:basalt_deltas")) {
            return new Color(115, 120, 128).getRGB();
        }
        return biome.func_225528_a_(0.0, 0.0);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemRegistry.SPECTRAFLY_SPAWN_EGG.get());
    }

    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_226125_Z_;
    }

    public boolean func_191957_ae() {
        return true;
    }

    public static boolean canSpawn(EntityType<DragonflyEntity> type, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return pos.func_177956_o() > 50;
    }
}

