/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.entities;

import blueduck.outerend.registry.ItemRegistry;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HimmeliteEntity
extends MonsterEntity {
    private static final DataParameter<Integer> BITE_FACTOR = EntityDataManager.func_187226_a(HimmeliteEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private Entity target = null;
    private boolean isRetreating = false;
    private int lastBiteFactor = 0;
    private boolean updateLastFactor;

    @OnlyIn(value=Dist.CLIENT)
    public int getLastBiteFactor() {
        return this.lastBiteFactor;
    }

    public HimmeliteEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70699_by = new GroundPathNavigator((MobEntity)this, worldIn);
        this.setBiteFactor(0);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.applyEntityAI();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BITE_FACTOR, (Object)0);
    }

    public void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{HimmeliteEntity.class}));
    }

    public static AttributeModifierMap createModifiers() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.35).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233818_a_, 10.0).func_233813_a_();
    }

    public Entity getNearest(Class<? extends LivingEntity> ... classes) {
        for (Class<? extends LivingEntity> clazz : classes) {
            LivingEntity e = this.field_70170_p.func_217360_a(clazz, EntityPredicate.field_221016_a.func_221014_c().func_221010_e().func_221012_a(entity -> {
                if (entity instanceof PlayerEntity) {
                    return !((PlayerEntity)entity).func_184812_l_();
                }
                return true;
            }), null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), new AxisAlignedBB(-16.0, -16.0, -16.0, 16.0, 16.0, 16.0).func_191194_a(this.func_213303_ch()));
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public int func_70693_a(PlayerEntity player) {
        return player.func_130014_f_().func_201674_k().nextInt(12);
    }

    public Path getPath() {
        if (!this.isRetreating) {
            this.target = this.getNearest(PlayerEntity.class, GolemEntity.class);
            if (this.target == null) {
                if (this.field_70173_aa % 300 == 1) {
                    Vector3d look = this.func_70040_Z();
                    if (this.field_70146_Z.nextBoolean() || this.field_70146_Z.nextBoolean() || this.field_70146_Z.nextBoolean()) {
                        look = Vector3d.func_189986_a((float)0.0f, (float)this.field_70146_Z.nextInt(360));
                    }
                    look = look.func_216372_d(1.0, 0.0, 1.0);
                    Vector3d targ = this.func_213303_ch();
                    for (int i = 0; i <= 16; ++i) {
                        targ = targ.func_178787_e(look);
                        if (!this.func_130014_f_().func_180495_p(new BlockPos(targ.func_82615_a(), targ.func_82617_b(), targ.func_82616_c())).func_196958_f()) {
                            if (!this.func_130014_f_().func_180495_p(new BlockPos(targ.func_82615_a(), targ.func_82617_b() + 1.0, targ.func_82616_c())).func_196958_f()) {
                                targ = targ.func_178787_e(look.func_186678_a(-1.0));
                                break;
                            }
                            targ = targ.func_72441_c(0.0, 1.0, 0.0);
                            continue;
                        }
                        if (!this.func_130014_f_().func_180495_p(new BlockPos(targ.func_82615_a(), targ.func_82617_b() - 1.0, targ.func_82616_c())).func_196958_f()) continue;
                        targ = targ.func_72441_c(0.0, -1.0, 0.0);
                        if (!this.func_130014_f_().func_180495_p(new BlockPos(targ.func_82615_a(), targ.func_82617_b() - 1.0, targ.func_82616_c())).func_196958_f()) continue;
                        targ = targ.func_72441_c(0.0, -1.0, 0.0);
                        if (!this.func_130014_f_().func_180495_p(new BlockPos(targ.func_82615_a(), targ.func_82617_b() - 1.0, targ.func_82616_c())).func_196958_f()) continue;
                        targ = targ.func_72441_c(0.0, 2.0, 0.0);
                        targ = targ.func_178787_e(look.func_186678_a(-1.0));
                        break;
                    }
                    return this.field_70699_by.func_179680_a(new BlockPos(targ.func_82615_a(), targ.func_82617_b(), targ.func_82616_c()), 1);
                }
                return null;
            }
            if (this.field_70699_by.func_75505_d() == null) {
                return this.field_70699_by.func_75494_a(this.target, 1);
            }
            BlockPos targetPos = this.func_70661_as().func_75505_d().func_224770_k();
            if (this.target.func_70092_e((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p()) > 1.0 && this.func_70032_d(this.target) >= 1.0f) {
                return this.field_70699_by.func_75494_a(this.target, 1);
            }
            return null;
        }
        if (this.field_70699_by.func_75500_f()) {
            Vector3d targ = this.func_70040_Z().func_186678_a(-16.0).func_178787_e(this.func_213303_ch());
            Path path = this.field_70699_by.func_179680_a(new BlockPos(targ.field_72450_a, targ.field_72448_b, targ.field_72449_c), 1);
            return path;
        }
        if (this.func_233580_cy_().func_177951_i((Vector3i)this.field_70699_by.func_208485_j()) <= 5.0 || this.func_70032_d(this.target) >= 10.0f) {
            this.isRetreating = false;
        }
        return null;
    }

    public void setBiteFactor(int amt) {
        this.field_70180_af.func_187227_b(BITE_FACTOR, (Object)amt);
    }

    public void incrementBiteFactor(int amt) {
        this.field_70180_af.func_187227_b(BITE_FACTOR, (Object)(this.getBiteFactor() + amt));
    }

    public int getBiteFactor() {
        return (Integer)this.field_70180_af.func_187225_a(BITE_FACTOR);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_175446_cd() || this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.field_72995_K && (this.updateLastFactor || this.getBiteFactor() == 0)) {
                this.lastBiteFactor = this.getBiteFactor();
                this.updateLastFactor = false;
            }
            return;
        }
        if (this.target != null && !this.isRetreating) {
            if (this.getBiteFactor() >= 17) {
                this.setBiteFactor(0);
            }
            if (this.func_70032_d(this.target) <= 10.0f && this.getBiteFactor() != 16) {
                this.incrementBiteFactor(1);
            } else if (this.func_70032_d(this.target) >= 10.0f) {
                this.setBiteFactor(0);
            }
            if (this.func_70032_d(this.target) <= 2.0f && this.getBiteFactor() == 16) {
                this.setBiteFactor(17);
                this.target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
                this.isRetreating = true;
                this.field_70699_by.func_75499_g();
            }
            this.func_200602_a(EntityAnchorArgument.Type.FEET, this.target.func_213303_ch());
        } else {
            this.setBiteFactor(-1);
        }
        Path path = this.getPath();
        if (path != null) {
            this.field_70699_by.func_75484_a(path, 1.0);
            this.func_213293_j(this.func_213322_ci().func_82615_a() + (double)0.01f, this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c());
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemRegistry.HIMMELITE_SPAWN_EGG.get());
    }

    public void markForRefresh() {
        this.updateLastFactor = true;
    }
}

