/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.entities;

import blueduck.outerend.registry.EntityRegistry;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StalkerEntity
extends AnimalEntity
implements IAngerable {
    public static final DataParameter<String> COLOR = EntityDataManager.func_187226_a(StalkerEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> ANGER_TIME = EntityDataManager.func_187226_a(BeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public String color = (String)this.func_184212_Q().func_187225_a(COLOR);
    public static String[] COLORS = new String[]{"rose", "mint", "cobalt"};
    private UUID angerTarget = null;
    private int recruitHelpTimer = 0;
    private int angryNoiseTimer = 0;
    private static final RangedInteger recruitHelpRange = TickRangeConverter.func_233037_a_((int)0, (int)1);
    private static final RangedInteger angryNoiseRange = TickRangeConverter.func_233037_a_((int)4, (int)6);
    private static final RangedInteger angerTimeRange = TickRangeConverter.func_233037_a_((int)20, (int)39);

    public StalkerEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.color = COLORS[worldIn.func_201674_k().nextInt(COLORS.length)];
        this.field_70180_af.func_187227_b(COLOR, (Object)this.color);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        StalkerEntity ent = (StalkerEntity)((EntityType)EntityRegistry.STALKER.get()).func_200721_a((World)p_241840_1_);
        ent.field_70180_af.func_187227_b(COLOR, p_241840_2_.func_184212_Q().func_187225_a(COLOR));
        return ent;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_185161_cS;
    }

    public static AttributeModifierMap createModifiers() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.26).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233818_a_, 16.0).func_233813_a_();
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new StalkerPanicGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new StalkerAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185161_cS}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new StalkerHurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((StalkerEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(3, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        if (this.func_233678_J__() && this.func_70638_az() != null) {
            this.tryRecruitHelp();
            this.tryPlayAngryNoise();
            this.field_70718_bc = this.field_70173_aa;
        }
    }

    private void tryRecruitHelp() {
        if (this.recruitHelpTimer-- <= 0) {
            if (this.func_70635_at().func_75522_a((Entity)this.func_70638_az())) {
                this.recruitHelp();
            }
            this.recruitHelpTimer = recruitHelpRange.func_233018_a_(this.field_70146_Z);
        }
    }

    private void recruitHelp() {
        double range = this.func_233637_b_(Attributes.field_233819_b_);
        Vector3d pos = this.func_213303_ch().func_72441_c(-0.5, -0.5, -0.5);
        AxisAlignedBB box = AxisAlignedBB.func_241549_a_((Vector3d)pos).func_72314_b(range, 10.0, range);
        LivingEntity target = this.func_70638_az();
        this.field_70170_p.func_225317_b(StalkerEntity.class, box).stream().filter(e -> e != this).filter(e -> e.func_70638_az() == null).filter(e -> !e.func_184191_r((Entity)target)).forEach(e -> e.func_70624_b(target));
    }

    private void tryPlayAngryNoise() {
        if (this.angryNoiseTimer-- <= 0) {
            this.playAngryNoise();
            this.angryNoiseTimer = angryNoiseRange.func_233018_a_(this.field_70146_Z);
        }
    }

    private void playAngryNoise() {
    }

    public void func_70624_b(@Nullable LivingEntity entity) {
        if (this.func_70638_az() == null && entity != null) {
            this.angryNoiseTimer = angryNoiseRange.func_233018_a_(this.field_70146_Z);
            this.recruitHelpTimer = recruitHelpRange.func_233018_a_(this.field_70146_Z);
        }
        if (entity instanceof PlayerEntity) {
            this.func_230246_e_((PlayerEntity)entity);
        }
        super.func_70624_b(entity);
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER_TIME);
    }

    public void func_230260_a__(int time) {
        this.field_70180_af.func_187227_b(ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public void func_230259_a_(@Nullable UUID uuid) {
        this.angerTarget = uuid;
    }

    public void func_230258_H__() {
        this.func_230260_a__(angerTimeRange.func_233018_a_(this.field_70146_Z));
    }

    public static boolean canStalkerSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return true;
    }

    public boolean func_213380_a(IWorld p_213380_1_, SpawnReason reason) {
        return true;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (!((String)this.func_184212_Q().func_187225_a(COLOR)).equals("")) {
            compound.func_74778_a("Color", (String)this.func_184212_Q().func_187225_a(COLOR));
        }
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (((String)this.func_184212_Q().func_187225_a(COLOR)).equals("")) {
            this.func_184212_Q().func_187227_b(COLOR, (Object)compound.func_74779_i("Color"));
        }
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)"");
        this.field_70180_af.func_187214_a(ANGER_TIME, (Object)0);
    }

    class StalkerHurtByTargetGoal
    extends HurtByTargetGoal {
        public StalkerHurtByTargetGoal(StalkerEntity stalker) {
            super((CreatureEntity)stalker, new Class[0]);
            this.func_220794_a(new Class[0]);
        }

        public boolean func_75253_b() {
            StalkerEntity stalker = (StalkerEntity)this.field_75299_d;
            return stalker.func_233678_J__() && super.func_75253_b();
        }

        protected void func_190105_f() {
            ((StalkerEntity)this.field_75299_d).recruitHelp();
        }

        protected void func_220793_a(MobEntity entity, LivingEntity target) {
            ((StalkerEntity)entity).playAngryNoise();
            entity.func_70624_b(target);
        }
    }

    public class StalkerPanicGoal
    extends PanicGoal {
        public StalkerPanicGoal(StalkerEntity stalker) {
            super((CreatureEntity)stalker, 2.0);
        }

        public boolean func_75250_a() {
            StalkerEntity stalker = (StalkerEntity)this.field_75267_a;
            return stalker.func_70874_b() < 0 && super.func_75250_a();
        }
    }

    public class StalkerAttackGoal
    extends MeleeAttackGoal {
        public StalkerAttackGoal(StalkerEntity stalker) {
            super((CreatureEntity)stalker, 1.0, false);
        }

        public boolean func_75250_a() {
            StalkerEntity stalker = (StalkerEntity)this.field_75441_b;
            return stalker.func_70874_b() >= 0 && super.func_75250_a();
        }
    }
}

