/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.features;

import blueduck.outerend.features.TreeGenerationContext;
import blueduck.outerend.features.helpers.RotatableFeaturePart;
import blueduck.outerend.registry.BlockRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class AzureTreeFeature
extends Feature<NoFeatureConfig> {
    private static IChunk chunkGenerating = null;
    private static final Direction[] offsets = new Direction[]{Direction.NORTH, Direction.UP, Direction.NORTH, Direction.UP, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.WEST, null, Direction.EAST, null, Direction.WEST, null, Direction.NORTH, Direction.UP, Direction.EAST, Direction.UP, Direction.DOWN, Direction.WEST, Direction.WEST, Direction.UP};
    private static final RotatableFeaturePart petalFoldPart = new RotatableFeaturePart(offsets);

    public AzureTreeFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!reader.func_180495_p(pos.func_177977_b()).func_235714_a_(BlockTags.func_199896_a().func_241834_b(new ResourceLocation("outer_end:end_plantable_on")))) {
            return false;
        }
        AzureTreeFeature.generateTree(new TreeGenerationContext<ISeedReader>(reader, pos, rand));
        return true;
    }

    public static <world extends IWorldReader & IWorldWriter> void generateTree(TreeGenerationContext context) {
        if (context.rand.nextBoolean() && context.rand.nextBoolean() && context.rand.nextBoolean() && context.rand.nextBoolean()) {
            AzureTreeFeature.generateTreeLarge(context);
        } else if (context.rand.nextBoolean() && context.rand.nextBoolean()) {
            AzureTreeFeature.generateTreeSmallest(context);
        } else {
            AzureTreeFeature.generateTreeSmall(context);
        }
    }

    public static <world extends IWorldReader & IWorldWriter> void generateTreeLarge(TreeGenerationContext context) {
        int yPos;
        Object world = context.world;
        BlockPos pos = context.pos;
        Random rand = context.rand;
        AzureTreeFeature.setBlock((IWorldWriter)world, pos, ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        int height = rand.nextInt(4) + 8;
        for (yPos = 0; yPos <= height; ++yPos) {
            if (yPos < height) {
                AzureTreeFeature.setLog(world, pos.func_177982_a(0, yPos, 0), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
            }
            if (yPos > 1 && yPos < height - 1) continue;
            AzureTreeFeature.setLog(world, pos.func_177982_a(1, yPos, 0), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
            AzureTreeFeature.setLog(world, pos.func_177982_a(-1, yPos, 0), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
            AzureTreeFeature.setLog(world, pos.func_177982_a(0, yPos, 1), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
            AzureTreeFeature.setLog(world, pos.func_177982_a(0, yPos, -1), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        }
        BlockState leavesState = (BlockState)((Block)BlockRegistry.AZURE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
        petalFoldPart.generate(Direction.NORTH, pos.func_177982_a(0, --yPos, 1), posPlace -> AzureTreeFeature.setLeaves(world, posPlace, leavesState));
        petalFoldPart.generate(Direction.SOUTH, pos.func_177982_a(0, yPos, -1), posPlace -> AzureTreeFeature.setLeaves(world, posPlace, leavesState));
        petalFoldPart.generate(Direction.EAST, pos.func_177982_a(-1, yPos, 0), posPlace -> AzureTreeFeature.setLeaves(world, posPlace, leavesState));
        petalFoldPart.generate(Direction.WEST, pos.func_177982_a(1, yPos, 0), posPlace -> AzureTreeFeature.setLeaves(world, posPlace, leavesState));
        AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos, 0), ((Block)BlockRegistry.AZURE_STAMEN.get()).func_176223_P());
        for (int stamenPosY = 0; stamenPosY < rand.nextInt(3) + 3; ++stamenPosY) {
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos + stamenPosY + 1, 0), ((Block)BlockRegistry.AZURE_STAMEN.get()).func_176223_P());
        }
    }

    public static <world extends IWorldReader & IWorldWriter> void generateTreeSmall(TreeGenerationContext context) {
        BlockState leavesState;
        int yPos;
        Object world = context.world;
        BlockPos pos = context.pos;
        Random rand = context.rand;
        AzureTreeFeature.setBlock((IWorldWriter)world, pos, ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        int height = rand.nextInt(4) + 6;
        for (yPos = 0; yPos < height; ++yPos) {
            AzureTreeFeature.setLog(world, pos.func_177982_a(0, yPos, 0), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        }
        AzureTreeFeature.setLog(world, pos.func_177982_a(1, 0, 0), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        AzureTreeFeature.setLog(world, pos.func_177982_a(-1, 0, 0), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        AzureTreeFeature.setLog(world, pos.func_177982_a(0, 0, 1), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        AzureTreeFeature.setLog(world, pos.func_177982_a(0, 0, -1), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        BlockState leavesState2 = (BlockState)((Block)BlockRegistry.AZURE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
        AzureTreeFeature.setLeaves(world, pos.func_177982_a(1, yPos - 1, 0), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.func_177982_a(-1, yPos - 1, 0), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos - 1, 1), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos - 1, -1), leavesState2);
        for (int horizontalOffset = 0; horizontalOffset <= 2; ++horizontalOffset) {
            leavesState = (BlockState)((Block)BlockRegistry.AZURE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(horizontalOffset + 1));
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(horizontalOffset, yPos, 0), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(-horizontalOffset, yPos, 0), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos, horizontalOffset), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos, -horizontalOffset), leavesState);
        }
        for (int yOff = 0; yOff <= 1; ++yOff) {
            leavesState = (BlockState)((Block)BlockRegistry.AZURE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(3));
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(1, yPos + yOff, 1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(1, yPos + yOff, -1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(-1, yPos + yOff, -1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(-1, yPos + yOff, 1), leavesState);
        }
        AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos + 1, 0), ((Block)BlockRegistry.AZURE_STAMEN.get()).func_176223_P());
    }

    public static <world extends IWorldReader & IWorldWriter> void generateTreeSmallest(TreeGenerationContext context) {
        BlockState leavesState;
        int yPos;
        Object world = context.world;
        BlockPos pos = context.pos;
        Random rand = context.rand;
        AzureTreeFeature.setBlock((IWorldWriter)world, pos, ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        int height = rand.nextInt(3) + 4;
        for (yPos = 0; yPos < height; ++yPos) {
            AzureTreeFeature.setLog(world, pos.func_177982_a(0, yPos, 0), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        }
        AzureTreeFeature.setLog(world, pos.func_177982_a(1, 0, 0), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        AzureTreeFeature.setLog(world, pos.func_177982_a(-1, 0, 0), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        AzureTreeFeature.setLog(world, pos.func_177982_a(0, 0, 1), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        AzureTreeFeature.setLog(world, pos.func_177982_a(0, 0, -1), ((Block)BlockRegistry.AZURE_STEM.get()).func_176223_P());
        BlockState leavesState2 = (BlockState)((Block)BlockRegistry.AZURE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
        AzureTreeFeature.setLeaves(world, pos.func_177982_a(1, yPos - 1, 0), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.func_177982_a(-1, yPos - 1, 0), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos - 1, 1), leavesState2);
        AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos - 1, -1), leavesState2);
        for (int horizontalOffset = 0; horizontalOffset <= 2; ++horizontalOffset) {
            leavesState = (BlockState)((Block)BlockRegistry.AZURE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(horizontalOffset + 1));
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(horizontalOffset, yPos, 0), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(-horizontalOffset, yPos, 0), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos, horizontalOffset), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos, -horizontalOffset), leavesState);
        }
        for (int yOff = 0; yOff <= 1; ++yOff) {
            leavesState = (BlockState)((Block)BlockRegistry.AZURE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(3));
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(1, yPos + yOff, 1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(1, yPos + yOff, -1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(-1, yPos + yOff, -1), leavesState);
            AzureTreeFeature.setLeaves(world, pos.func_177982_a(-1, yPos + yOff, 1), leavesState);
        }
        AzureTreeFeature.setLeaves(world, pos.func_177982_a(0, yPos + 1, 0), ((Block)BlockRegistry.AZURE_STAMEN.get()).func_176223_P());
    }

    protected static <world extends IWorldReader & IWorldWriter> void setLeaves(world world, BlockPos pos, BlockState state) {
        if (world.func_180495_p(pos).canBeReplacedByLeaves(world, pos)) {
            AzureTreeFeature.setBlock(world, pos, state);
        }
    }

    protected static <world extends IWorldReader & IWorldWriter> void setLog(world world, BlockPos pos, BlockState state) {
        if (world.func_180495_p(pos).canBeReplacedByLogs(world, pos)) {
            AzureTreeFeature.setBlock(world, pos, state);
        }
    }

    protected static void setBlock(IWorldWriter world, BlockPos pos, BlockState state) {
        if (world instanceof WorldGenRegion) {
            if (chunkGenerating == null || !chunkGenerating.func_76632_l().equals((Object)new ChunkPos(pos))) {
                chunkGenerating = ((WorldGenRegion)world).func_217349_x(pos);
            }
            chunkGenerating.func_177436_a(pos, state, false);
        } else {
            world.func_180501_a(pos, state, 3);
        }
    }
}

