/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.features;

import blueduck.outerend.registry.BlockRegistry;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import shadow.com.terraformersmc.terraform.shapes.api.Position;
import shadow.com.terraformersmc.terraform.shapes.api.Quaternion;
import shadow.com.terraformersmc.terraform.shapes.api.Shape;
import shadow.com.terraformersmc.terraform.shapes.impl.Shapes;
import shadow.com.terraformersmc.terraform.shapes.impl.filler.SimpleFiller;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.pathfinder.AddLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.BendLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.DilateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.RotateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.TranslateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.validator.SafelistValidator;

public class CrystalSpikeFeature
extends Feature<NoFeatureConfig> {
    public CrystalSpikeFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockState VIOLITE = ((Block)BlockRegistry.VIOLITE.get()).func_176223_P();
        List<BlockState> WHITELIST = Arrays.asList(VIOLITE, Blocks.field_150350_a.func_176223_P(), Blocks.field_150377_bs.func_176223_P());
        while (reader.func_175623_d(pos.func_177977_b()) && pos.func_177956_o() != 0) {
            pos = pos.func_177977_b();
        }
        while (reader.func_180495_p(pos.func_177984_a()) == VIOLITE && pos.func_177956_o() != 255) {
            pos = pos.func_177984_a();
        }
        if (reader.func_180495_p(pos.func_177977_b()) == VIOLITE) {
            int shards = random.nextInt(3) + 1;
            for (int i = 0; i < shards; ++i) {
                BlockState CRYSTAL_TYPE = ((Block)BlockTags.func_199896_a().func_241834_b(new ResourceLocation("outer_end:crystal_blocks")).func_205596_a(random)).func_176223_P();
                double length = random.nextDouble() * 7.0 + 3.0;
                double radius = random.nextDouble() * 0.3 + 2.0;
                double arc = random.nextDouble() * 30.0;
                double Xrot = random.nextDouble() * 25.0;
                double Zrot = random.nextDouble() * 10.0;
                double Yrot = random.nextDouble() * 360.0 * (double)(i + 1);
                double movementDown = length / 4.0;
                double scale = random.nextDouble() / 2.0 + 0.7;
                Shape shape = Shape.of(point -> false, Position.of(0.0, 0.0, 0.0), Position.of(0.0, 0.0, 0.0));
                shape.applyLayer(new AddLayer(Shapes.ellipticalPyramid(radius, radius, length).applyLayer(new BendLayer(arc, radius, length)).applyLayer(new RotateLayer(Quaternion.of(Xrot, Yrot, Zrot, true))))).applyLayer(new DilateLayer(Position.of(scale, scale, scale))).applyLayer(new TranslateLayer(Position.of(pos))).applyLayer(new TranslateLayer(Position.of(0.0, -movementDown, 0.0))).validate(new SafelistValidator((IWorldGenerationBaseReader)reader, WHITELIST), validShape -> validShape.fill(new SimpleFiller((IWorldWriter)reader, CRYSTAL_TYPE)));
            }
            return true;
        }
        return false;
    }
}

