/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.mixin_code;

import blueduck.outerend.registry.BiomeRegistry;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.SimplexNoiseGenerator;

public class MixinHelpers {
    public static PerlinNoiseGenerator generatorPerlin = new PerlinNoiseGenerator(new SharedSeedRandom(new Random().nextLong()), (List)ImmutableList.of((Object)0));
    public static SimplexNoiseGenerator generator = new SimplexNoiseGenerator(new Random());
    public static SimplexNoiseGenerator generator1 = new SimplexNoiseGenerator(new Random());
    public static SimplexNoiseGenerator generator2 = new SimplexNoiseGenerator(new Random());

    public static double get(float x, float z) {
        return MixinHelpers.getRandomNoise(generator1, x, z) / 2.0f + MixinHelpers.getRandomNoise(null, x, z) / 2.0f;
    }

    public static void resetGenerator(long seed) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        Random r = new Random(seed);
        for (int i = 0; i <= new Random(seed).nextInt(4) + 3; ++i) {
            numbers.add(r.nextInt(5));
        }
        generatorPerlin = new PerlinNoiseGenerator(new SharedSeedRandom(seed), (List)ImmutableList.copyOf(numbers));
        generator = new SimplexNoiseGenerator(new Random(seed));
        generator2 = new SimplexNoiseGenerator(new Random(new Random(seed).nextLong()));
    }

    public static Biome getBiome(float x, float z, Biome defaultBiome, Registry<Biome> lookupRegistry) {
        for (Biome b : BiomeRegistry.getBiomes()) {
            double noise = MixinHelpers.get(x + BiomeRegistry.getWeightRangeForBiome(b), z + BiomeRegistry.getWeightForBiome(b));
            if (!(noise <= (double)(BiomeRegistry.getWeightForBiome(b) + BiomeRegistry.getWeightRangeForBiome(b))) || !(noise >= (double)(BiomeRegistry.getWeightForBiome(b) - BiomeRegistry.getWeightRangeForBiome(b)))) continue;
            if (lookupRegistry == null) {
                return b;
            }
            return (Biome)lookupRegistry.func_82594_a(b.getRegistryName());
        }
        return defaultBiome;
    }

    public static float floatBitShift(int input, int amt) {
        boolean isNegative = amt < 0;
        float out = (float)input / (float)(amt + 1);
        return out;
    }

    public static float getRandomNoise(SimplexNoiseGenerator noiseGenerator, float x, float z) {
        if (noiseGenerator == null) {
            return (float)generator.func_227464_a_((double)(x / 100.0f), (double)(z / 100.0f), generator2.func_151605_a((double)(x / 100.0f), (double)(z / 100.0f)) / 1.0) * 200.0f;
        }
        float i = x / 2.0f;
        float j = z / 2.0f;
        float k = x % 2.0f;
        float l = z % 2.0f;
        float f = 100.0f - MathHelper.func_76129_c((float)(x * x + z * z)) * 8.0f;
        f = MathHelper.func_76131_a((float)f, (float)-100.0f, (float)80.0f);
        for (int i1 = -12; i1 <= 12; ++i1) {
            for (int j1 = -12; j1 <= 12; ++j1) {
                long k1 = (long)(i + (float)i1);
                long l1 = (long)(j + (float)j1);
                if (k1 * k1 + l1 * l1 <= 4096L || !(noiseGenerator.func_151605_a((double)k1, (double)l1) < (double)-0.9f)) continue;
                float f1 = (MathHelper.func_76135_e((float)k1) * 3439.0f + MathHelper.func_76135_e((float)l1) * 147.0f) % 13.0f + 9.0f;
                float f2 = k - (float)(i1 * 2);
                float f3 = l - (float)(j1 * 2);
                float f4 = 100.0f - MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3)) * f1;
                f4 = MathHelper.func_76131_a((float)f4, (float)-100.0f, (float)80.0f);
                f = Math.max(f, f4);
            }
        }
        return f;
    }
}

