/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.registry;

import blueduck.outerend.OuterEndMod;
import blueduck.outerend.biomes.AzureForest;
import blueduck.outerend.biomes.CrystalCrag;
import com.minecraftabnormals.abnormals_core.core.util.BiomeUtil;
import java.util.HashMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BiomeRegistry {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)OuterEndMod.MODID);
    public static final RegistryObject<Biome> AZURE_FOREST = BIOMES.register("azure_forest", () -> new AzureForest().getBiome());
    public static final RegistryObject<Biome> CRYSTAL_CRAG = BIOMES.register("crystal_crag", () -> new CrystalCrag().getBiome());
    private static final HashMap<Biome, Float> OUTER_END_BIOMES_WEIGHT_RANGES = new HashMap();
    private static final HashMap<ResourceLocation, Biome> OUTER_END_BIOMES = new HashMap();
    private static final HashMap<Biome, Float> OUTER_END_BIOME_WEIGHTS = new HashMap();

    public static void init() {
        BIOMES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static Biome[] getBiomes() {
        return OUTER_END_BIOMES.values().toArray(new Biome[0]);
    }

    public static float getWeightForBiome(Biome biome) {
        return OUTER_END_BIOME_WEIGHTS.get(biome).floatValue();
    }

    private static void register(Biome biome, ResourceLocation registryName, float weight, float weightRange, RegistryEvent.Register<Biome> event) {
        BiomeUtil.addEndBiome((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName()), (int)((int)weight));
        OUTER_END_BIOMES.put(registryName, (Biome)ForgeRegistries.BIOMES.getValue(registryName));
        OUTER_END_BIOME_WEIGHTS.put(BiomeRegistry.getBiomes()[OUTER_END_BIOME_WEIGHTS.size()], Float.valueOf(weight));
        OUTER_END_BIOMES_WEIGHT_RANGES.put(BiomeRegistry.getBiomes()[OUTER_END_BIOMES_WEIGHT_RANGES.size()], Float.valueOf(weightRange));
    }

    public static float getWeightRangeForBiome(Biome biome) {
        return OUTER_END_BIOMES_WEIGHT_RANGES.get(biome).floatValue();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="outer_end")
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerEvent(RegistryEvent.Register<Biome> event) {
            BiomeRegistry.register((Biome)AZURE_FOREST.get(), AZURE_FOREST.getId(), OuterEndMod.CONFIG.AZURE_FOREST_WEIGHT.get().intValue(), OuterEndMod.CONFIG.AZURE_FOREST_WEIGHT.get().intValue(), (RegistryEvent.Register<Biome>)event);
            BiomeRegistry.register((Biome)CRYSTAL_CRAG.get(), CRYSTAL_CRAG.getId(), OuterEndMod.CONFIG.CRYSTAL_CRAG_WEIGHT.get().intValue(), OuterEndMod.CONFIG.CRYSTAL_CRAG_WEIGHT.get().intValue(), (RegistryEvent.Register<Biome>)event);
        }
    }
}

