/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.mod;

import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import subaraki.paintings.config.ConfigurationHandler;
import subaraki.paintings.mod.client.RenderPaintingLate;
import subaraki.paintings.mod.server.proxy.CommonProxy;
import subaraki.paintings.sets.PaintingsGibea;
import subaraki.paintings.sets.PaintingsInsane;
import subaraki.paintings.sets.PaintingsMassive;
import subaraki.paintings.sets.PaintingsNewInsane;
import subaraki.paintings.sets.PaintingsSphax;
import subaraki.paintings.sets.PaintingsTiny;

@Mod(modid="morepaintings", name="Paintings++", version="1.10.2-3.2.0.1", dependencies="after:PaintingSelGui", acceptedMinecraftVersions="[1.11]")
public class Paintings {
    public static final String MODID = "morepaintings";
    public static final String VERSION = "1.10.2-3.2.0.1";
    public static final String NAME = "Paintings++";
    @SidedProxy(serverSide="subaraki.paintings.mod.server.proxy.CommonProxy", clientSide="subaraki.paintings.mod.client.proxy.ClientProxy")
    public static CommonProxy proxy;
    private static final String CLASS_LOC = "com.mcf.davidee.paintinggui.gui.PaintingButton";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata modMeta = event.getModMetadata();
        modMeta.authorList = Arrays.asList("Subaraki");
        modMeta.autogenerated = false;
        modMeta.credits = "Subaraki";
        modMeta.description = "More Paintings ! Check config file for options";
        modMeta.url = "http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/1287285-/";
        ConfigurationHandler.instance.loadConfig(event.getSuggestedConfigurationFile());
        this.loadPaintingGui();
        proxy.registerRenderInformation();
    }

    public void loadPaintingGui() {
        switch (ConfigurationHandler.instance.texture) {
            case "gibea": {
                PaintingsGibea.addPaintings();
                break;
            }
            case "sphax": {
                PaintingsSphax.addPaintings();
                break;
            }
            case "insane": {
                PaintingsInsane.addPaintings();
                break;
            }
            case "tinypics": {
                PaintingsTiny.addPaintings();
                break;
            }
            case "new_insane": {
                PaintingsNewInsane.addPaintings();
                break;
            }
            case "massive": {
                PaintingsMassive.addPaintings();
            }
        }
        try {
            Class<?> altClass = Class.forName(CLASS_LOC);
            this.paintingGuiTextureHelper(altClass, "TEXTURE", new ResourceLocation("subaraki:art/" + ConfigurationHandler.instance.texture + ".png"));
            this.paintingGuiHelper(altClass, "KZ_WIDTH", (int)RenderPaintingLate.getSize());
            this.paintingGuiHelper(altClass, "KZ_HEIGHT", (int)RenderPaintingLate.getSize());
        }
        catch (Exception e) {
            FMLLog.bigWarning((String)"Davidees painting mod not installed or to old/new. Skipping", (Object[])new Object[0]);
        }
    }

    private void paintingGuiHelper(Class c, String field, int value) throws Exception {
        Field f = c.getField(field);
        f.setAccessible(true);
        f.set(null, value);
    }

    private void paintingGuiTextureHelper(Class c, String field, ResourceLocation loc) throws Exception {
        Field f = c.getField(field);
        f.setAccessible(true);
        f.set(null, loc);
    }
}

