/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.client;

import io.github.foundationgames.phonos.sound.MultiPositionedSoundInstance;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;

@Environment(value=EnvType.CLIENT)
public class ClientRecieverLocationStorage {
    private static final Int2ObjectMap<ArrayList<Long>> channelStorage = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<Map<class_2338, class_1113>> stoppableSoundStorage = new Int2ObjectOpenHashMap();
    private static final List<SoundConsumer> playSoundCallbacks = new ArrayList<SoundConsumer>();

    public static void addReciever(int channel, long pos) {
        channelStorage.putIfAbsent(channel, new ArrayList());
        ArrayList l = (ArrayList)channelStorage.get(channel);
        if (!l.contains(pos)) {
            l.add(pos);
        }
    }

    public static void removeReciever(int channel, long pos) {
        channelStorage.putIfAbsent(channel, new ArrayList());
        ((ArrayList)channelStorage.get(channel)).remove(pos);
    }

    public static void clear() {
        channelStorage.clear();
    }

    public static void playSound(class_3414 sound, int channel, float volume, float pitch) {
        ClientRecieverLocationStorage.playSound(sound.method_14833(), channel, volume, pitch);
    }

    public static void playSound(class_2960 sound, int channel, float volume, float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)new MultiPositionedSoundInstance((List<Long>)((List)channelStorage.get(channel)), sound, volume, pitch));
        for (SoundConsumer c : playSoundCallbacks) {
            c.apply(sound, (List)channelStorage.get(channel), channel, volume, pitch, false);
        }
    }

    public static void playStoppableSound(class_2338 pos, class_3414 sound, int channel, float volume, float pitch) {
        ClientRecieverLocationStorage.playStoppableSound(pos, sound.method_14833(), channel, volume, pitch);
    }

    public static void playStoppableSound(class_2338 pos, class_2960 sound, int channel, float volume, float pitch) {
        class_1144 manager = class_310.method_1551().method_1483();
        ClientRecieverLocationStorage.tryStopSound(pos, channel);
        MultiPositionedSoundInstance instance = new MultiPositionedSoundInstance((List<Long>)((List)channelStorage.get(channel)), sound, volume, pitch);
        manager.method_4873((class_1113)instance);
        if (!stoppableSoundStorage.containsKey(channel)) {
            stoppableSoundStorage.put(channel, new HashMap());
        }
        ((Map)stoppableSoundStorage.get(channel)).put(pos, instance);
        for (SoundConsumer c : playSoundCallbacks) {
            c.apply(sound, (List)channelStorage.get(channel), channel, volume, pitch, true);
        }
    }

    public static void tryStopSound(class_2338 pos, int channel) {
        class_1144 manager = class_310.method_1551().method_1483();
        if (stoppableSoundStorage.containsKey(channel)) {
            manager.method_4870((class_1113)((Map)stoppableSoundStorage.get(channel)).get(pos));
            ((Map)stoppableSoundStorage.get(channel)).remove(pos);
        }
    }

    public static boolean isStoppablePlaying(class_2338 pos, int channel) {
        class_1144 manager = class_310.method_1551().method_1483();
        return manager.method_4877((class_1113)((Map)stoppableSoundStorage.get(channel)).get(pos));
    }

    public static boolean isChannelPlaying(int channel) {
        class_1144 manager = class_310.method_1551().method_1483();
        if (stoppableSoundStorage.containsKey(channel)) {
            for (class_2338 pos : ((Map)stoppableSoundStorage.get(channel)).keySet()) {
                if (!manager.method_4877((class_1113)((Map)stoppableSoundStorage.get(channel)).get(pos))) continue;
                return true;
            }
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerPlaySoundCallback(SoundConsumer consumer) {
        playSoundCallbacks.add(consumer);
    }

    public static void init() {
    }

    @FunctionalInterface
    public static interface SoundConsumer {
        public void apply(class_2960 var1, List<Long> var2, int var3, float var4, float var5, boolean var6);
    }
}

