/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.screen;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WSlider;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.foundationgames.phonos.Phonos;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class CustomMusicDiscGuiDescription
extends SyncedGuiDescription {
    private final class_1799 stack;
    private final int stackSlot;
    private final WTextField soundField;
    private final WLabel errorLabel;
    private int comparatorOutput = 0;

    public CustomMusicDiscGuiDescription(int syncId, class_1661 playerInventory, int stackSlot) {
        super(Phonos.CUSTOM_DISC_HANDLER, syncId, playerInventory);
        WLabel errorLabel;
        this.stack = playerInventory.method_5438(stackSlot);
        this.stackSlot = stackSlot;
        WGridPanel root = new WGridPanel(9);
        root.setSize(300, 66);
        this.setRootPanel((WPanel)root);
        WTextField soundIdField = new WTextField();
        soundIdField.setEditable(true);
        soundIdField.setMaxLength(99);
        soundIdField.setText(this.stack.method_7911("MusicData").method_10558("SoundId"));
        this.soundField = soundIdField;
        root.add((WWidget)soundIdField, 0, 1, 24, 7);
        WLabel comparatorLabel = new WLabel((class_2561)new class_2585(""));
        root.add((WWidget)comparatorLabel, 8, 4, 20, 7);
        WSlider comparatorOutField = new WSlider(1, 15, Axis.HORIZONTAL);
        comparatorOutField.setValue(this.stack.method_7911("MusicData").method_10550("ComparatorSignal"));
        comparatorOutField.setDraggingFinishedListener(i -> {
            this.comparatorOutput = i;
            comparatorLabel.setText((class_2561)new class_2585(Integer.toString(i)));
        });
        root.add((WWidget)comparatorOutField, 0, 4, 18, 4);
        WButton confirmSoundButton = new WButton();
        confirmSoundButton.setLabel((class_2561)new class_2588("button.phonos.set_sound_id"));
        confirmSoundButton.setOnClick(() -> this.setStackSoundId(soundIdField.getText()));
        root.add((WWidget)confirmSoundButton, 25, 1, 8, 1);
        WButton confirmComparatorButton = new WButton();
        confirmComparatorButton.setLabel((class_2561)new class_2588("button.phonos.set_comparator_signal"));
        confirmComparatorButton.setOnClick(() -> {
            this.setDiscComparatorSignal(comparatorOutField.getValue());
            this.success("log.phonos.comparator_signal_success");
        });
        root.add((WWidget)confirmComparatorButton, 19, 4, 14, 7);
        this.errorLabel = errorLabel = new WLabel((class_2561)new class_2585(""));
        root.add((WWidget)errorLabel, 0, 7);
        root.validate((GuiDescription)this);
    }

    public static void registerServerPackets() {
        ServerSidePacketRegistry.INSTANCE.register(Phonos.id("set_disc_sound_id"), (ctx, buf) -> {
            class_1799 stack = ctx.getPlayer().field_7514.method_5438(buf.readInt());
            String soundId = buf.method_10800(Short.MAX_VALUE);
            ctx.getTaskQueue().execute(() -> stack.method_7911("MusicData").method_10582("SoundId", soundId));
        });
        ServerSidePacketRegistry.INSTANCE.register(Phonos.id("set_disc_comparator_signal"), (ctx, buf) -> {
            class_1799 stack = ctx.getPlayer().field_7514.method_5438(buf.readInt());
            int signal = buf.readInt();
            ctx.getTaskQueue().execute(() -> stack.method_7911("MusicData").method_10569("ComparatorSignal", signal));
        });
    }

    @Environment(value=EnvType.CLIENT)
    private void setDiscSoundId(String sid) {
        this.stack.method_7911("MusicData").method_10582("SoundId", sid);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(this.stackSlot);
        buf.method_10814(sid);
        ClientSidePacketRegistry.INSTANCE.sendToServer(Phonos.id("set_disc_sound_id"), buf);
    }

    @Environment(value=EnvType.CLIENT)
    private void setDiscComparatorSignal(int signal) {
        this.stack.method_7911("MusicData").method_10569("ComparatorSignal", signal);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(this.stackSlot);
        buf.writeInt(signal);
        ClientSidePacketRegistry.INSTANCE.sendToServer(Phonos.id("set_disc_comparator_signal"), buf);
    }

    private void setStackSoundId(String sid) {
        class_2960 id = class_2960.method_12829((String)sid);
        if (id == null) {
            this.error("log.phonos.sound_id_error");
        } else {
            this.setDiscSoundId(id.toString());
            this.success("log.phonos.sound_id_success");
        }
    }

    private void error(String errorKey) {
        this.errorLabel.setText((class_2561)new class_2588(errorKey).method_27692(class_124.field_1061));
    }

    private void success(String successKey) {
        this.errorLabel.setText((class_2561)new class_2588(successKey).method_27692(class_124.field_1077));
    }
}

