/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.addons.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.addons.jei.carver.CarverRecipe;
import net.kaneka.planttech2.addons.jei.crossbreeding.CrossbreedingRecipe;
import net.kaneka.planttech2.addons.jei.machine_growing.MachineGrowingRecipe;
import net.kaneka.planttech2.addons.jei.machinebulbreprocessor.MachinebulbReprocessorRecipe;
import net.kaneka.planttech2.crops.CropEntry;
import net.kaneka.planttech2.crops.CropList;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.items.MachineBulbItem;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.ChipalyzerRecipe;
import net.kaneka.planttech2.recipes.recipeclasses.CompressorRecipe;
import net.kaneka.planttech2.recipes.recipeclasses.InfuserRecipe;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;

public class RecipeGetter {
    public static List<ChipalyzerRecipe> getChipalyzerRecipes() {
        ArrayList<ChipalyzerRecipe> results = new ArrayList<ChipalyzerRecipe>();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        for (IRecipe recipe : recipeManager.func_199510_b()) {
            if (recipe.func_222127_g() != ModRecipeTypes.CHIPALYZER) continue;
            ChipalyzerRecipe chipalyzerrecipe = (ChipalyzerRecipe)recipe;
            results.add(chipalyzerrecipe);
        }
        return results;
    }

    public static List<CompressorRecipe> getCompressorRecipes() {
        ArrayList<CompressorRecipe> results = new ArrayList<CompressorRecipe>();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        for (IRecipe recipe : recipeManager.func_199510_b()) {
            if (recipe.func_222127_g() != ModRecipeTypes.COMPRESSING) continue;
            CompressorRecipe compressorrecipe = (CompressorRecipe)recipe;
            results.add(compressorrecipe);
        }
        return results;
    }

    public static List<InfuserRecipe> getInfuserRecipes() {
        ArrayList<InfuserRecipe> results = new ArrayList<InfuserRecipe>();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        for (IRecipe recipe : recipeManager.func_199510_b()) {
            if (recipe.func_222127_g() != ModRecipeTypes.INFUSING) continue;
            InfuserRecipe compressorrecipe = (InfuserRecipe)recipe;
            results.add(compressorrecipe);
        }
        return results;
    }

    public static List<CrossbreedingRecipe> getCrossbreedingRecipes() {
        ArrayList<CrossbreedingRecipe> results = new ArrayList<CrossbreedingRecipe>();
        CropList croplist = PlantTechMain.getCropList();
        for (CropEntry entry : croplist.values()) {
            if (!entry.getConfiguration().isEnabled() || entry.getParents().isEmpty()) continue;
            ItemStack output = entry.getPrimarySeed().getItemStack();
            for (ParentPair parent : entry.getParents()) {
                results.add(new CrossbreedingRecipe(output, croplist.getByName(parent.getFirstParent()).getPrimarySeed().getItemStack(), croplist.getByName(parent.getSecondParent()).getPrimarySeed().getItemStack()));
            }
        }
        return results;
    }

    public static List<CarverRecipe> getCarverRecipes() {
        ArrayList<CarverRecipe> results = new ArrayList<CarverRecipe>();
        results.add(new CarverRecipe(new ItemStack((IItemProvider)Blocks.field_150339_S), new ItemStack((IItemProvider)ModBlocks.MACHINESHELL_IRON)));
        results.add(new CarverRecipe(new ItemStack((IItemProvider)ModBlocks.PLANTIUM_BLOCK), new ItemStack((IItemProvider)ModBlocks.MACHINESHELL_PLANTIUM)));
        return results;
    }

    public static List<MachinebulbReprocessorRecipe> getMachinebulbReprocessorRecipes() {
        ArrayList<MachinebulbReprocessorRecipe> results = new ArrayList<MachinebulbReprocessorRecipe>();
        for (Supplier<MachineBulbItem> bulb : ModItems.MACHINE_BULBS) {
            results.add(new MachinebulbReprocessorRecipe(bulb.get().getTier(), new ItemStack((IItemProvider)bulb.get()), bulb.get().getNeededBiomass()));
        }
        return results;
    }

    public static List<MachineGrowingRecipe> getMachineGrowingRecipes() {
        ArrayList<MachineGrowingRecipe> results = new ArrayList<MachineGrowingRecipe>();
        for (Supplier<MachineBulbItem> bulb : ModItems.MACHINE_BULBS) {
            results.add(new MachineGrowingRecipe(new ItemStack((IItemProvider)bulb.get()), new ItemStack((IItemProvider)bulb.get().getHull()), new ItemStack((IItemProvider)bulb.get().getMachine())));
        }
        return results;
    }
}

