/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import net.kaneka.planttech2.blocks.GrowingBlock;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CarverBlock
extends Block {
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    protected static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(p_199775_0_ -> ((Direction)p_199775_0_.getKey()).func_176740_k().func_176722_c()).collect(Util.func_199749_a());

    public CarverBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200943_b(0.5f).func_200944_c());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        directions.add(Direction.NORTH);
        directions.add(Direction.EAST);
        directions.add(Direction.SOUTH);
        directions.add(Direction.WEST);
        Collections.shuffle(directions);
        for (Direction direction : directions) {
            BlockState state2 = world.func_180495_p(pos.func_177972_a(direction));
            Block block = state2.func_177230_c();
            if (!this.checkForGrowable(block)) continue;
            if (block == Blocks.field_150339_S) {
                world.func_175656_a(pos.func_177972_a(direction), ModBlocks.MACHINESHELL_IRON_GROWING.func_176223_P());
                break;
            }
            if (block == ModBlocks.PLANTIUM_BLOCK) {
                world.func_175656_a(pos.func_177972_a(direction), ModBlocks.MACHINESHELL_PLANTIUM_GROWING.func_176223_P());
                break;
            }
            if (block != ModBlocks.MACHINESHELL_IRON_GROWING && block != ModBlocks.MACHINESHELL_PLANTIUM_GROWING) break;
            ((GrowingBlock)block).grow(state2, world, pos.func_177972_a(direction));
            break;
        }
    }

    public BlockRenderType func_149645_b(BlockState iBlockState) {
        return BlockRenderType.MODEL;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)EAST, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)EAST, state.func_177229_b((Property)NORTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)WEST, state.func_177229_b((Property)SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    private boolean checkForConnection(BlockState state) {
        Block block = state.func_177230_c();
        return this.checkForGrowable(block) || block == ModBlocks.MACHINESHELL_IRON || block == ModBlocks.MACHINESHELL_PLANTIUM;
    }

    private boolean checkForGrowable(Block block) {
        return block == Blocks.field_150339_S || block == ModBlocks.PLANTIUM_BLOCK || block == ModBlocks.MACHINESHELL_IRON_GROWING || block == ModBlocks.MACHINESHELL_PLANTIUM_GROWING;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL ? (BlockState)stateIn.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.checkForConnection(facingState))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.checkForConnection(world.func_180495_p(pos.func_177978_c()))))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.checkForConnection(world.func_180495_p(pos.func_177974_f()))))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.checkForConnection(world.func_180495_p(pos.func_177968_d()))))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.checkForConnection(world.func_180495_p(pos.func_177976_e()))));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, WEST, SOUTH});
    }
}

