/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.items.AdvancedAnalyserItem;
import net.kaneka.planttech2.items.AnalyserItem;
import net.kaneka.planttech2.items.CropRemover;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.tileentity.CropsTileEntity;
import net.kaneka.planttech2.tileentity.machine.CropAuraGeneratorTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CropBaseBlock
extends ContainerBlock {
    public static final IntegerProperty GROWSTATE = IntegerProperty.func_177719_a((String)"growstate", (int)0, (int)7);
    private final String entryName;

    public CropBaseBlock(String entryName) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200943_b(0.5f));
        this.entryName = entryName;
        this.setRegistryName(entryName + "_crop");
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CropsTileEntity();
    }

    public void updateCrop(World world, BlockPos pos, HashMapCropTraits traits) {
        BlockState state = world.func_180495_p(pos);
        int growstate = (Integer)state.func_177229_b((Property)GROWSTATE);
        if (growstate < 7 && this.canGrow(world, pos, traits)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)GROWSTATE, (Comparable)Integer.valueOf(growstate + 1)));
        } else {
            List<BlockPos> neighborpos = this.getNeighborBlockPosRandom(pos);
            for (BlockPos blockpos : neighborpos) {
                if (world.func_180495_p(blockpos).func_177230_c() != ModBlocks.CROPBARS) continue;
                List<BlockPos> cropbarneighbors = this.getNeighborBlockPosRandomExeptOne(blockpos, pos);
                for (BlockPos possiblePartner : cropbarneighbors) {
                    TileEntity tileEntity;
                    BlockState partnerState = world.func_180495_p(possiblePartner);
                    if (!(partnerState.func_177230_c() instanceof CropBaseBlock) || !((tileEntity = world.func_175625_s(possiblePartner)) instanceof CropsTileEntity)) continue;
                    HashMapCropTraits partnertraits = ((CropsTileEntity)tileEntity).getTraits();
                    world.func_175656_a(blockpos, this.func_176223_P());
                    if (!(world.func_175625_s(blockpos) instanceof CropsTileEntity) || !(world.func_175625_s(pos) instanceof CropsTileEntity)) continue;
                    ((CropsTileEntity)world.func_175625_s(blockpos)).setTraits(((CropsTileEntity)world.func_175625_s(pos)).getTraits().calculateNewTraits(partnertraits));
                    break;
                }
                if (world.func_180495_p(blockpos).func_177230_c() instanceof CropBaseBlock) break;
                world.func_175656_a(blockpos, this.func_176223_P());
                if (!(world.func_175625_s(blockpos) instanceof CropsTileEntity) || !(world.func_175625_s(pos) instanceof CropsTileEntity)) break;
                ((CropsTileEntity)world.func_175625_s(blockpos)).setTraits(((CropsTileEntity)world.func_175625_s(pos)).getTraits().copy());
                break;
            }
        }
    }

    public void updateCreative(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        int growstate = (Integer)state.func_177229_b((Property)GROWSTATE);
        if (growstate < 7) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)GROWSTATE, (Comparable)Integer.valueOf(7)));
        }
    }

    private List<BlockPos> getNeighborBlockPosRandom(BlockPos pos) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.func_177978_c());
        neighbors.add(pos.func_177974_f());
        neighbors.add(pos.func_177968_d());
        neighbors.add(pos.func_177976_e());
        Collections.shuffle(neighbors);
        return neighbors;
    }

    private List<BlockPos> getNeighborBlockPosRandomExeptOne(BlockPos pos, BlockPos exept) {
        List<BlockPos> neighbors = this.getNeighborBlockPosRandom(pos);
        neighbors.remove(exept);
        return neighbors;
    }

    private boolean canGrow(World world, BlockPos pos, HashMapCropTraits traits) {
        if (!this.enoughLight(world, pos, traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY))) {
            return false;
        }
        if (!this.enoughWater(world, pos, traits.getTrait(EnumTraitsInt.WATERSENSITIVITY))) {
            return false;
        }
        if (!this.rightSoil(world, pos, traits.getType())) {
            return false;
        }
        return this.rightTemperature(world, pos, traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE));
    }

    public String[] canGrowString(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        String[] messages = new String[10];
        if (te instanceof CropsTileEntity) {
            HashMapCropTraits traits = ((CropsTileEntity)te).getTraits();
            if (!this.enoughLight(world, pos, traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY))) {
                messages[1] = "Not enough light";
            }
            if (!this.enoughWater(world, pos, traits.getTrait(EnumTraitsInt.WATERSENSITIVITY))) {
                messages[2] = "Not enough water";
            }
            if (!this.rightSoil(world, pos, traits.getType())) {
                messages[3] = "Not right soil";
            }
            if (!this.rightTemperature(world, pos, traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE))) {
                messages[4] = "Not right temperature";
            }
        } else {
            messages[0] = "error";
        }
        return messages;
    }

    public boolean enoughLight(World world, BlockPos pos, int lightsensitivity) {
        if (!world.isAreaLoaded(pos, 1)) {
            return false;
        }
        return world.func_205049_d(pos, 0) >= 14 - lightsensitivity;
    }

    public boolean enoughWater(World world, BlockPos pos, int waterSensitivity) {
        for (BlockPos blockpos$mutableblockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1 * (waterSensitivity + 1), 0, -1 * (waterSensitivity + 1)), (BlockPos)pos.func_177982_a(waterSensitivity + 1, -1, waterSensitivity + 1))) {
            BlockState state = world.func_180495_p(blockpos$mutableblockpos);
            if (state.func_185904_a() != Material.field_151586_h && (!state.func_235901_b_((Property)BlockStateProperties.field_208198_y) || !((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue())) continue;
            return true;
        }
        return false;
    }

    public boolean rightSoil(World world, BlockPos pos, String name) {
        Block block = PlantTechMain.getCropList().getByName(name).getConfiguration().getSoil().get();
        BlockState state = world.func_180495_p(pos.func_177977_b());
        return state.func_177230_c() == block || state.func_177230_c() == ModBlocks.UNIVERSAL_SOIL_INFUSED;
    }

    public boolean rightTemperature(World world, BlockPos pos, String name, int tolerance) {
        EnumTemperature temp = PlantTechMain.getCropList().getByName(name).getConfiguration().getTemperature();
        return temp.inRange(world.func_225523_d_().func_226836_a_(pos).func_225486_c(pos), tolerance);
    }

    private List<CropAuraGeneratorTileEntity> getCropAuraGeneratorsInRadius(World world, BlockPos centre, int radius) {
        ArrayList<CropAuraGeneratorTileEntity> list = new ArrayList<CropAuraGeneratorTileEntity>();
        for (int x = centre.func_177958_n() - radius; x < centre.func_177958_n() + radius; ++x) {
            for (int y = centre.func_177956_o() - radius; y < centre.func_177956_o() + radius; ++y) {
                for (int z = centre.func_177952_p() - radius; z < centre.func_177952_p() + radius; ++z) {
                    TileEntity te;
                    BlockPos itr = new BlockPos(x, y, z);
                    if (world.func_180495_p(itr).func_177230_c() != ModBlocks.CROP_AURA_GENERATOR || !((te = world.func_175625_s(itr)) instanceof CropAuraGeneratorTileEntity)) continue;
                    list.add((CropAuraGeneratorTileEntity)te);
                }
            }
        }
        return list;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{GROWSTATE});
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        return willHarvest && !player.func_184812_l_() || super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175655_b(pos, false);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        int growstate = (Integer)state.func_177229_b((Property)GROWSTATE);
        if (growstate > 6 && hand.equals((Object)Hand.MAIN_HAND) && !worldIn.field_72995_K) {
            ItemStack holdItem = player.func_184586_b(Hand.MAIN_HAND);
            if (!holdItem.func_190926_b() && (holdItem.func_77973_b() instanceof AnalyserItem || holdItem.func_77973_b() instanceof AdvancedAnalyserItem || holdItem.func_77973_b() instanceof CropRemover)) {
                return ActionResultType.PASS;
            }
            NonNullList drops = NonNullList.func_191196_a();
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof CropsTileEntity) {
                ((CropsTileEntity)te).dropsRemoveOneSeed((NonNullList<ItemStack>)drops, growstate);
                for (ItemStack stack : drops) {
                    CropBaseBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
                }
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)GROWSTATE, (Comparable)Integer.valueOf(0)));
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, hand, ray);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList drops = Lists.newArrayList();
        int growstate = (Integer)state.func_177229_b((Property)GROWSTATE);
        Vector3d vec3d = (Vector3d)builder.func_216019_b(LootParameters.field_237457_g_);
        if (vec3d != null) {
            BlockPos pos = new BlockPos(vec3d);
            TileEntity te = builder.func_216018_a().func_175625_s(pos);
            if (te instanceof CropsTileEntity) {
                ((CropsTileEntity)te).addDrops(drops, growstate);
                drops.add(new ItemStack((IItemProvider)ModBlocks.CROPBARS));
            }
        }
        return drops;
    }

    public BlockRenderType func_149645_b(BlockState iBlockState) {
        return BlockRenderType.MODEL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public static boolean isOpaque(VoxelShape shape) {
        return true;
    }

    public static class ColorHandler
    implements IBlockColor {
        public int getColor(BlockState state, IBlockDisplayReader blockDisplayReader, BlockPos pos, int tintindex) {
            if (tintindex == 0) {
                return PlantTechMain.getCropList().getByName(((CropBaseBlock)state.func_177230_c()).getEntryName()).getSeedColor();
            }
            return -1;
        }
    }
}

