/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ElectricFenceGate
extends Block {
    public static final DirectionProperty HORIZONTAL_FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    public static final BooleanProperty IS_TOP = BooleanProperty.func_177716_a((String)"is_top");
    public static final VoxelShape FRAME_Z = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)1.0, (double)16.0, (double)10.0), (VoxelShape)Block.func_208617_a((double)15.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0));
    public static final VoxelShape FRAME_X = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)1.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0, (double)16.0));
    public static final VoxelShape FRAME_TOP_Z = Block.func_208617_a((double)0.0, (double)15.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    public static final VoxelShape FRAME_TOP_X = Block.func_208617_a((double)6.0, (double)15.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final VoxelShape DOOR_CLOSE_Z = Block.func_208617_a((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)16.0, (double)9.0);
    public static final VoxelShape DOOR_CLOSE_X = Block.func_208617_a((double)7.0, (double)0.0, (double)1.0, (double)9.0, (double)16.0, (double)15.0);
    public static final VoxelShape DOOR_NEGATIVE_Z = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)15.0);
    public static final VoxelShape DOOR_POSITIVE_Z = Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape DOOR_NEGATIVE_X = Block.func_208617_a((double)1.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape DOOR_POSITIVE_X = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0);

    public ElectricFenceGate(AbstractBlock.Properties property) {
        super(property.func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)IS_TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HORIZONTAL_FACING, OPEN, IS_TOP});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState state;
        if (!this.checkValid(currentPos, (World)worldIn)) {
            worldIn.func_175655_b(currentPos, (Boolean)stateIn.func_177229_b((Property)IS_TOP) == false);
        }
        if ((state = worldIn.func_180495_p((Boolean)stateIn.func_177229_b((Property)IS_TOP) != false ? currentPos.func_177977_b() : currentPos.func_177984_a())).func_177230_c() instanceof ElectricFenceGate) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, state.func_177229_b((Property)HORIZONTAL_FACING))).func_206870_a((Property)OPEN, state.func_177229_b((Property)OPEN))).func_206870_a((Property)IS_TOP, stateIn.func_177229_b((Property)IS_TOP));
        }
        return stateIn;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)IS_TOP, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!this.checkValid(pos, worldIn)) {
            worldIn.func_175655_b(pos, (Boolean)state.func_177229_b((Property)IS_TOP) == false);
            return ActionResultType.FAIL;
        }
        worldIn.func_175656_a(pos, (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, state.func_177229_b((Property)HORIZONTAL_FACING))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)OPEN) == false))).func_206870_a((Property)IS_TOP, state.func_177229_b((Property)IS_TOP)));
        worldIn.func_217378_a(player, (Boolean)state.func_177229_b((Property)OPEN) != false ? 1005 : 1011, pos, 0);
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        worldIn.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)HORIZONTAL_FACING, state.func_177229_b((Property)HORIZONTAL_FACING))).func_206870_a((Property)OPEN, state.func_177229_b((Property)OPEN))).func_206870_a((Property)IS_TOP, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape;
        Direction facing = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
        boolean open = (Boolean)state.func_177229_b((Property)OPEN);
        boolean top = (Boolean)state.func_177229_b((Property)IS_TOP);
        switch (facing) {
            default: {
                shape = DOOR_CLOSE_Z;
                if (!open) break;
                shape = top ? this.toTopShape(DOOR_NEGATIVE_Z) : DOOR_NEGATIVE_Z;
                break;
            }
            case SOUTH: {
                shape = DOOR_CLOSE_Z;
                if (!open) break;
                shape = top ? this.toTopShape(DOOR_POSITIVE_Z) : DOOR_POSITIVE_Z;
                break;
            }
            case WEST: {
                shape = DOOR_CLOSE_X;
                if (!open) break;
                shape = top ? this.toTopShape(DOOR_NEGATIVE_X) : DOOR_NEGATIVE_X;
                break;
            }
            case EAST: {
                shape = DOOR_CLOSE_X;
                if (!open) break;
                shape = top ? this.toTopShape(DOOR_POSITIVE_X) : DOOR_POSITIVE_X;
            }
        }
        switch (facing.func_176740_k()) {
            default: {
                shape = this.add(shape, FRAME_Z);
                if (!top) break;
                shape = this.add(shape, FRAME_TOP_Z);
                break;
            }
            case X: {
                shape = this.add(shape, FRAME_X);
                if (!top) break;
                shape = this.add(shape, FRAME_TOP_X);
            }
        }
        return shape;
    }

    private VoxelShape add(VoxelShape shape, VoxelShape shape2) {
        return VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)shape2);
    }

    private VoxelShape toTopShape(VoxelShape shape) {
        AxisAlignedBB aabb = shape.func_197752_a();
        return Block.func_208617_a((double)(aabb.field_72340_a * 16.0), (double)(aabb.field_72338_b * 16.0 - 1.0), (double)(aabb.field_72339_c * 16.0), (double)(aabb.field_72336_d * 16.0), (double)(aabb.field_72337_e * 16.0 - 1.0), (double)(aabb.field_72334_f * 16.0));
    }

    private boolean checkValid(BlockPos pos, World world) {
        BlockState state = world.func_180495_p(pos);
        BlockState state2 = world.func_180495_p((Boolean)state.func_177229_b((Property)IS_TOP) != false ? pos.func_177977_b() : pos.func_177984_a());
        return state2.func_177230_c() instanceof ElectricFenceGate && state.func_177229_b((Property)IS_TOP) != state2.func_177229_b((Property)IS_TOP);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("can be dismantled by wrench"));
    }
}

