/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.baseclasses;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CustomFenceBlock
extends Block {
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    protected static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(p_199775_0_ -> ((Direction)p_199775_0_.getKey()).func_176740_k().func_176722_c()).collect(Util.func_199749_a());
    protected VoxelShape[] collisionShapes;
    protected VoxelShape[] shapes;
    private final Object2IntMap<BlockState> field_223008_i = new Object2IntOpenHashMap();

    public CustomFenceBlock(AbstractBlock.Properties property) {
        super(property);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.collisionShapes = this.makeShapes(1.0f, 1.0f, 24.0f, 0.0f, 24.0f);
        this.shapes = this.makeShapes(1.0f, 1.0f, 16.0f, 0.0f, 16.0f);
    }

    public boolean func_220111_a(BlockState p_220111_1_, boolean p_220111_2_, Direction p_220111_3_) {
        Block block = p_220111_1_.func_177230_c();
        boolean flag = block.func_203417_a((ITag)BlockTags.field_219748_G) && p_220111_1_.func_185904_a() == this.field_149764_J;
        boolean flag1 = block instanceof FenceGateBlock && FenceGateBlock.func_220253_a((BlockState)p_220111_1_, (Direction)p_220111_3_);
        boolean flag2 = block instanceof CustomFenceBlock;
        return !CustomFenceBlock.func_220073_a((Block)block) && p_220111_2_ || flag || flag1 || flag2;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177978_c();
        BlockPos blockpos2 = blockpos.func_177974_f();
        BlockPos blockpos3 = blockpos.func_177968_d();
        BlockPos blockpos4 = blockpos.func_177976_e();
        BlockState blockstate = iblockreader.func_180495_p(blockpos1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos3);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos4);
        return (BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.func_220111_a(blockstate, Block.func_220055_a((IWorldReader)iblockreader, (BlockPos)blockpos1, (Direction)Direction.SOUTH), Direction.SOUTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.func_220111_a(blockstate1, Block.func_220055_a((IWorldReader)iblockreader, (BlockPos)blockpos2, (Direction)Direction.WEST), Direction.WEST)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.func_220111_a(blockstate2, Block.func_220055_a((IWorldReader)iblockreader, (BlockPos)blockpos3, (Direction)Direction.NORTH), Direction.NORTH)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.func_220111_a(blockstate3, Block.func_220055_a((IWorldReader)iblockreader, (BlockPos)blockpos4, (Direction)Direction.EAST), Direction.EAST)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)EAST, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)EAST, state.func_177229_b((Property)NORTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)WEST, state.func_177229_b((Property)SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getIndex(state)];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.collisionShapes[this.getIndex(state)];
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.collisionShapes[this.getIndex(state)];
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL ? (BlockState)stateIn.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.func_220111_a(facingState, Block.func_220055_a((IWorldReader)worldIn, (BlockPos)facingPos, (Direction)facing.func_176734_d()), facing.func_176734_d()))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected int getIndex(BlockState state) {
        return this.field_223008_i.computeIntIfAbsent((Object)state, p_223007_0_ -> {
            int i = 0;
            if (((Boolean)p_223007_0_.func_177229_b((Property)NORTH)).booleanValue()) {
                i |= CustomFenceBlock.getMask(Direction.NORTH);
            }
            if (((Boolean)p_223007_0_.func_177229_b((Property)EAST)).booleanValue()) {
                i |= CustomFenceBlock.getMask(Direction.EAST);
            }
            if (((Boolean)p_223007_0_.func_177229_b((Property)SOUTH)).booleanValue()) {
                i |= CustomFenceBlock.getMask(Direction.SOUTH);
            }
            if (((Boolean)p_223007_0_.func_177229_b((Property)WEST)).booleanValue()) {
                i |= CustomFenceBlock.getMask(Direction.WEST);
            }
            return i;
        });
    }

    private static int getMask(Direction facing) {
        return 1 << facing.func_176736_b();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, WEST, SOUTH});
    }

    protected VoxelShape[] makeShapes(float nodeWidth, float extensionWidth, float p_196408_3_, float p_196408_4_, float p_196408_5_) {
        float f = 8.0f - nodeWidth;
        float f1 = 8.0f + nodeWidth;
        float f2 = 8.0f - extensionWidth;
        float f3 = 8.0f + extensionWidth;
        VoxelShape voxelshape = Block.func_208617_a((double)f, (double)0.0, (double)f, (double)f1, (double)p_196408_3_, (double)f1);
        VoxelShape voxelshape1 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)0.0, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape2 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.func_208617_a((double)0.0, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape4 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)f2, (double)16.0, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape5 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{VoxelShapes.func_197880_a(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }
}

