/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.container;

import java.util.Arrays;
import java.util.function.Predicate;
import net.kaneka.planttech2.energy.IItemChargeable;
import net.kaneka.planttech2.items.KnowledgeChip;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryFluidTileEntity;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BaseContainer
extends Container {
    protected final EnergyInventoryTileEntity tileentity;
    protected final IIntArray fieldArray;

    public BaseContainer(int id, ContainerType<?> type, PlayerInventory player, EnergyInventoryTileEntity tileentity, int slots) {
        super(type, id);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)player, x + y * 9 + 9, 23 + x * 18, 106 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)player, x, 23 + x * 18, 164));
        }
        this.tileentity = tileentity;
        this.fieldArray = tileentity.getIntArray();
        this.func_216961_a(this.fieldArray);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.tileentity.isUsableByPlayer(playerIn);
    }

    public EnergyTileEntity getTE() {
        return this.tileentity;
    }

    public int getValue(int id) {
        return this.fieldArray.func_221476_a(id);
    }

    protected LimitedItemInfoSlot createSpeedUpgradeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.speedupgrade").setConditions(stack -> {
            Item item = stack.func_77973_b();
            return item instanceof TierItem && ((TierItem)item).getItemType() == TierItem.ItemType.SPEED_UPGRADE;
        }).setLimited();
    }

    protected LimitedItemInfoSlot createRangeUpgradeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.rangeupgrade").setConditions(stack -> {
            Item item = stack.func_77973_b();
            return item instanceof TierItem && ((TierItem)item).getItemType() == TierItem.ItemType.RANGE_UPGRADE;
        }).setLimited();
    }

    protected LimitedItemInfoSlot createKnowledgeChipSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, this.tileentity.getKnowledgeChipSlot(), xPosition, yPosition, "slot.util.knowledgechip").setConditions(stack -> stack.func_77973_b() instanceof KnowledgeChip);
    }

    protected LimitedItemInfoSlot createCapacityChipSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return (LimitedItemInfoSlot)new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.energystorageupgrade").setConditions(stack -> {
            Item item = stack.func_77973_b();
            return item instanceof TierItem && ((TierItem)item).getItemType() == TierItem.ItemType.CAPACITY_UPGRADE;
        }).setLimited().setShouldListen();
    }

    protected LimitedItemInfoSlot createEnergyInSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, this.tileentity.getEnergyInSlot(), xPosition, yPosition, "slot.util.energyin").setConditions(stack -> stack.func_77973_b() instanceof IItemChargeable);
    }

    protected LimitedItemInfoSlot createEnergyOutSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, this.tileentity.getEnergyOutSlot(), xPosition, yPosition, "slot.util.energyout").setConditions(stack -> stack.func_77973_b() instanceof IItemChargeable);
    }

    protected LimitedItemInfoSlot createFluidInSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, ((EnergyInventoryFluidTileEntity)this.tileentity).getFluidInSlot(), xPosition, yPosition, "slot.util.fluidin");
    }

    protected LimitedItemInfoSlot createFluidOutSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, ((EnergyInventoryFluidTileEntity)this.tileentity).getFluidOutSlot(), xPosition, yPosition, "slot.util.fluidout");
    }

    protected LimitedItemInfoSlot createFakeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, String usage) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, usage).setConditions(false);
    }

    protected LimitedItemInfoSlot createOutoutSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.output").setConditions(false);
    }

    protected LimitedItemInfoSlot createDNAContainerSlot(IItemHandler handler, int index, int xPosition, int yPosition, String usage, boolean isEmpty) {
        return new LimitedItemInfoSlot(handler, index, xPosition, yPosition, usage).setConditions(stack -> isEmpty && stack.func_77973_b() == ModItems.DNA_CONTAINER_EMPTY || !isEmpty && stack.func_77973_b() == ModItems.DNA_CONTAINER && stack.func_77942_o());
    }

    public class LimitedItemInfoSlot
    extends SlotItemHandlerWithInfo {
        private Predicate<ItemStack> conditions;
        private boolean limited;

        public LimitedItemInfoSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, String usage) {
            super(itemHandler, index, xPosition, yPosition, usage);
            this.conditions = stack -> true;
            this.limited = false;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.conditions.test(stack);
        }

        public int func_178170_b(ItemStack stack) {
            return this.limited ? 1 : super.func_178170_b(stack);
        }

        public LimitedItemInfoSlot setLimited() {
            this.limited = true;
            return this;
        }

        public LimitedItemInfoSlot setConditions(boolean enabled) {
            this.conditions = stack -> enabled;
            return this;
        }

        public LimitedItemInfoSlot setConditions(Item ... acceptableItems) {
            this.conditions = stack -> acceptableItems.length == 0 || Arrays.stream(acceptableItems).anyMatch(item -> stack.func_77973_b() == item);
            return this;
        }

        public LimitedItemInfoSlot setConditions(Predicate<ItemStack> conditions) {
            this.conditions = conditions;
            return this;
        }
    }

    public class SlotItemHandlerWithInfo
    extends SlotItemHandler {
        private final String usage;
        protected boolean listening;

        public SlotItemHandlerWithInfo(IItemHandler itemHandler, int index, int xPosition, int yPosition, String usage) {
            super(itemHandler, index, xPosition, yPosition);
            this.listening = false;
            this.usage = usage;
        }

        public String getUsageString() {
            return this.usage;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (this.listening) {
                BaseContainer.this.func_75142_b();
                BaseContainer.this.tileentity.onContainerUpdated(this.getSlotIndex());
            }
        }

        public SlotItemHandlerWithInfo setShouldListen() {
            this.listening = true;
            return this;
        }
    }
}

