/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropEntryConfigData;
import net.kaneka.planttech2.crops.CropList;
import net.kaneka.planttech2.crops.CropListReloadListener;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CropConfigProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;

    public CropConfigProvider(DataGenerator generator) {
        this.dataGenerator = generator;
    }

    public abstract Map<ResourceLocation, CropEntryConfigData> getCropData();

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.dataGenerator.func_200391_b();
        Map<ResourceLocation, CropEntryConfigData> cropEntryData = this.getCropData();
        this.validate(PlantTechMain.getCropList(), cropEntryData);
        cropEntryData.forEach((key, data) -> {
            Path outputFile = CropConfigProvider.getPath(path, key);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)CropListReloadListener.toJson(data), (Path)outputFile);
            }
            catch (Exception ioexception) {
                LOGGER.error("Couldn't save crop entry configuration {}", (Object)outputFile, (Object)ioexception);
            }
        });
    }

    protected void validate(CropList list, Map<ResourceLocation, CropEntryConfigData> dataMap) {
        AtomicBoolean errored = new AtomicBoolean(false);
        dataMap.forEach((loc, data) -> {
            if (list.getByName(data.getCropEntryName()) == null) {
                LOGGER.fatal("Unknown crop entry {} in {}", (Object)data.getCropEntryName(), loc);
                errored.set(true);
            }
            data.getParents().forEach(parentPair -> {
                if (list.getByName(parentPair.getFirstParent()) == null) {
                    LOGGER.fatal("Unknown first parent crop entry {} in {}: {}", (Object)parentPair.getFirstParent(), loc, parentPair);
                    errored.set(true);
                }
                if (list.getByName(parentPair.getSecondParent()) == null) {
                    LOGGER.fatal("Unknown second parent crop entry {} in {}: {}", (Object)parentPair.getSecondParent(), loc, parentPair);
                    errored.set(true);
                }
            });
        });
        if (errored.get()) {
            throw new RuntimeException("Unknown crop entries found during validation. Check the log for details");
        }
    }

    private static Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.func_110624_b() + "/" + "pt2_crops" + "/" + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Crop Entry Configurations";
    }
}

