/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.kaneka.planttech2.crops.CropEntryConfigData;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ObjectSupplier;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.utilities.ISerializable;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class CropConfiguration
implements ISerializable {
    private final boolean enabled;
    private final EnumTemperature temperature;
    private final DropEntry primarySeed;
    private final List<Supplier<Item>> seeds;
    private final List<DropEntry> drops;
    private final List<ParentPair> parents;
    private final Supplier<Block> soil;

    public CropConfiguration(CompoundNBT compound) {
        this(compound.func_74767_n("enabled"), EnumTemperature.byName(compound.func_74779_i("temperature")), DropEntry.of(compound.func_74775_l("primaryseed")), NBTHelper.constructListFromString(compound, "seeds", name -> () -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name))), NBTHelper.constructListFromCompound(compound, "drops", DropEntry::of), NBTHelper.constructListFromCompound(compound, "parents", ParentPair::of), () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.func_74779_i("soil"))));
    }

    public CropConfiguration(boolean enabled, EnumTemperature temperature, DropEntry primarySeed, List<Supplier<Item>> seeds, List<DropEntry> drops, List<ParentPair> parents, Supplier<Block> soil) {
        this.enabled = enabled;
        this.temperature = temperature;
        this.primarySeed = primarySeed;
        this.seeds = seeds;
        this.drops = drops;
        this.parents = parents;
        this.soil = soil;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74757_a("enabled", this.enabled);
        compound.func_74778_a("temperature", this.temperature.toString());
        compound.func_218657_a("primaryseed", (INBT)this.primarySeed.write());
        NBTHelper.putList(compound, "seeds", this.seeds, seed -> StringNBT.func_229705_a_((String)((Item)seed.get()).getRegistryName().toString()));
        NBTHelper.putSerilizableList(compound, "drops", this.drops);
        NBTHelper.putSerilizableList(compound, "parents", this.parents);
        compound.func_74778_a("soil", this.soil.get().getRegistryName().toString());
        return compound;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public EnumTemperature getTemperature() {
        return this.temperature;
    }

    public DropEntry getPrimarySeed() {
        return this.primarySeed;
    }

    public List<Supplier<Item>> getSeeds() {
        return this.seeds;
    }

    public List<DropEntry> getDrops() {
        return this.drops;
    }

    public List<ParentPair> getParents() {
        return this.parents;
    }

    public Supplier<Block> getSoil() {
        return this.soil;
    }

    public float getMutateChanceForParents(String parent1, String parent2) {
        return this.parents.stream().filter(parentPair -> parentPair.test(parent1, parent2)).map(ParentPair::getMutationChance).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static CropConfiguration fromConfigData(CropEntryConfigData data) {
        return new CropConfiguration(data.isEnabled(), data.getTemperature(), data.getPrimarySeed(), data.getSeeds(), data.getDrops(), data.getParents(), data.getSoil());
    }

    public static Builder builder(DropEntry primarySeed) {
        return new Builder(primarySeed);
    }

    public static class Builder {
        boolean enabled = true;
        EnumTemperature temperature = EnumTemperature.NORMAL;
        final DropEntry primarySeed;
        final List<Supplier<Item>> seeds = new ArrayList<Supplier<Item>>();
        final List<DropEntry> drops = new ArrayList<DropEntry>();
        final List<ParentPair> parents = new ArrayList<ParentPair>();
        Supplier<Block> soil = () -> Blocks.field_150346_d;

        public Builder(DropEntry primarySeed) {
            this.primarySeed = primarySeed;
        }

        public CropConfiguration build() {
            return new CropConfiguration(this.enabled, this.temperature, this.primarySeed, this.seeds, this.drops, this.parents, this.soil);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabled() {
            return this.enabled(true);
        }

        public Builder disabled() {
            return this.enabled(false);
        }

        public Builder temperature(EnumTemperature newTemp) {
            this.temperature = newTemp;
            return this;
        }

        public Builder seed(Supplier<Item> item) {
            this.seeds.add(item);
            return this;
        }

        public Builder seed(ResourceLocation item) {
            return this.seed(ObjectSupplier.of(item, ForgeRegistries.ITEMS));
        }

        public Builder seed(String item) {
            return this.seed(new ResourceLocation(item));
        }

        public Builder parents(ParentPair entry) {
            this.parents.add(entry);
            return this;
        }

        public Builder parents(String parent1, String parent2, float chance) {
            return this.parents(ParentPair.of(parent1, parent2, chance));
        }

        public Builder parents(ParentPair ... entries) {
            this.parents.addAll(Arrays.asList(entries));
            return this;
        }

        public Builder drop(DropEntry entry) {
            this.drops.add(entry);
            return this;
        }

        public Builder drop(Supplier<Item> item, int min, int max) {
            return this.drop(DropEntry.of(item, min, max));
        }

        public Builder drop(ResourceLocation item, int min, int max) {
            return this.drop(ObjectSupplier.of(item, ForgeRegistries.ITEMS), min, max);
        }

        public Builder drop(String item, int min, int max) {
            return this.drop(new ResourceLocation(item), min, max);
        }

        public Builder drop(DropEntry ... entries) {
            this.drops.addAll(Arrays.asList(entries));
            return this;
        }

        public Builder soil(Supplier<Block> newSoil) {
            this.soil = newSoil;
            return this;
        }
    }
}

