/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.kaneka.planttech2.crops.CropConfiguration;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.utilities.ISerializable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CropEntry
implements Comparable<CropEntry>,
ISerializable {
    private final String name;
    private final int seedColor;
    private final boolean hasParticle;
    private final CropConfiguration defaultConfig;
    private CropConfiguration currentConfig;

    public CropEntry(CompoundNBT compound) {
        this(compound.func_74779_i("name"), compound.func_74762_e("colour"), compound.func_74767_n("hasparticle"), new CropConfiguration(compound.func_74775_l("defaultconfig")));
        this.currentConfig = new CropConfiguration(compound.func_74775_l("currentconfig"));
    }

    public CropEntry(String name, int seedColor, boolean hasParticle, CropConfiguration defaultConfig) {
        this.name = name;
        this.seedColor = seedColor;
        this.hasParticle = hasParticle;
        this.currentConfig = this.defaultConfig = defaultConfig;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("name", this.name);
        compound.func_74768_a("colour", this.seedColor);
        compound.func_74757_a("hasparticle", this.hasParticle);
        compound.func_218657_a("defaultconfig", (INBT)this.defaultConfig.write());
        compound.func_218657_a("currentconfig", (INBT)this.currentConfig.write());
        return compound;
    }

    public String getName() {
        return this.name;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("crop." + this.name);
    }

    public int getSeedColor() {
        return this.seedColor;
    }

    public boolean hasParticle() {
        return this.hasParticle;
    }

    public void setConfiguration(CropConfiguration config) {
        if (config == null) {
            config = this.defaultConfig;
        }
        this.currentConfig = config;
    }

    public CropConfiguration getConfiguration() {
        return this.currentConfig;
    }

    public boolean isSeed(Item item) {
        return this.getConfiguration().getSeeds().stream().anyMatch(sup -> sup.get() == item);
    }

    public List<ItemStack> calculateDrops(List<ItemStack> drops, HashMapCropTraits traits, int growstate, Random rand) {
        ItemStack seed = this.getPrimarySeed().getDroppedStack(traits.getTrait(EnumTraitsInt.FERTILITY), EnumTraitsInt.FERTILITY.getMax(), rand);
        if (!seed.func_190926_b()) {
            if (growstate < 7) {
                seed.func_190920_e(1);
            }
            drops.add(traits.addToItemStack(seed));
        }
        if (growstate > 6) {
            List<DropEntry> dropEntries = this.getConfiguration().getDrops();
            for (int i = 1; i < dropEntries.size(); ++i) {
                DropEntry drop = dropEntries.get(i);
                ItemStack addDrop = drop.getDroppedStack(traits.getTrait(EnumTraitsInt.PRODUCTIVITY), EnumTraitsInt.PRODUCTIVITY.getMax(), rand);
                if (addDrop.func_190926_b()) continue;
                drops.add(addDrop);
            }
        }
        return drops;
    }

    public NonNullList<ItemStack> calculateDropsReduced(NonNullList<ItemStack> drops, HashMapCropTraits traits, int growstate, Random rand) {
        List<DropEntry> dropEntries = this.getConfiguration().getDrops();
        if (growstate > 6) {
            ItemStack seed = this.getPrimarySeed().getDroppedStack(traits.getTrait(EnumTraitsInt.FERTILITY), EnumTraitsInt.FERTILITY.getMax(), rand);
            if (!seed.func_190926_b() && seed.func_190916_E() > 1) {
                seed.func_190918_g(1);
                drops.add((Object)traits.addToItemStack(seed));
            }
            for (DropEntry drop : dropEntries) {
                ItemStack stack = drop.getDroppedStack(traits.getTrait(EnumTraitsInt.PRODUCTIVITY), EnumTraitsInt.PRODUCTIVITY.getMax(), rand);
                if (stack.func_190926_b()) continue;
                drops.add((Object)stack);
            }
        }
        return drops;
    }

    public boolean isChild(String parent1, String parent2) {
        return this.getConfiguration().getParents().stream().anyMatch(pair -> pair.test(parent1, parent2));
    }

    public List<Supplier<Item>> getSeeds() {
        return this.getConfiguration().getSeeds();
    }

    public List<DropEntry> getAdditionalDrops() {
        return this.getConfiguration().getDrops();
    }

    public DropEntry getPrimarySeed() {
        return this.getConfiguration().getPrimarySeed();
    }

    public List<ParentPair> getParents() {
        return this.getConfiguration().getParents();
    }

    public boolean isEnabled() {
        return this.getConfiguration().isEnabled();
    }

    @Override
    public int compareTo(CropEntry o) {
        return this.getName().compareTo(o.getName());
    }
}

